/*
 * Decompiled with CFR 0.152.
 */
package cn.lemon.view.adapter;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import cn.lemon.view.adapter.BaseViewHolder;
import cn.lemon.view.adapter.RecyclerAdapter;
import cn.lemon.view.adapter.ViewHolderManager;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultiTypeAdapter
extends RecyclerAdapter {
    private final String TAG = "MultiTypeAdapter";
    private List<Object> mViewsData = new ArrayList<Object>();
    private ViewHolderManager mViewHolderManager = new ViewHolderManager();

    public MultiTypeAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewType(int position) {
        if (this.hasEndStatusView() && position == this.mViewCount - 1) {
            return 333;
        }
        return this.mViewHolderManager.getViewType(position);
    }

    @Override
    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        this.log("onCreateViewHolder -- viewType : " + viewType);
        if (this.mViewHolderManager == null) {
            throw new ExceptionInInitializerError("mViewHolderManager is null , it need init");
        }
        if (viewType == 333) {
            return new BaseViewHolder(this.mStatusView);
        }
        Class<? extends BaseViewHolder> clazzViewHolder = this.mViewHolderManager.getViewHolderClass(viewType);
        try {
            Constructor<? extends BaseViewHolder> constructor = clazzViewHolder.getDeclaredConstructor(ViewGroup.class);
            constructor.setAccessible(true);
            BaseViewHolder holder = constructor.newInstance(parent);
            if (holder == null) {
                constructor = clazzViewHolder.getDeclaredConstructor(new Class[0]);
                holder = constructor.newInstance(new Object[0]);
            }
            return holder;
        }
        catch (Exception e) {
            Log.e((String)"MultiTypeAdapter", (String)("onCreateBaseViewHolder : " + e.getMessage()));
            return null;
        }
    }

    public BaseViewHolder onCreateBaseViewHolder(ViewGroup parent, int viewType) {
        return null;
    }

    public void onBindViewHolder(BaseViewHolder holder, int position) {
        this.log("onBindViewHolder -- position : " + position);
        if (!this.mIsNoMoring && this.mLoadMoreEnable && !this.mIsLoadMoring && this.isValidLoadMore(position)) {
            this.mIsLoadMoring = true;
            this.setViewVisible(this.mLoadMoreLayout, true);
            this.setViewVisible(this.mLoadMoreView, true);
            this.setViewVisible((View)this.mLoadMoreError, false);
            this.setViewVisible((View)this.mNoMoreView, false);
            this.log("load more");
            if (this.mLoadMoreAction != null) {
                this.mLoadMoreAction.onAction();
            }
        } else if (this.mViewsData != null && holder != null && position < this.mViewsData.size()) {
            holder.setData(this.mViewsData.get(position));
        }
    }

    public <T> void add(Class<? extends BaseViewHolder<T>> viewHolder, T data) {
        if (this.mIsNoMoring || data == null || viewHolder == null) {
            return;
        }
        this.mIsLoadMoring = false;
        this.mViewsData.add(data);
        this.mViewHolderManager.addViewHolder(viewHolder);
        int viewType = this.mViewHolderManager.getViewType(viewHolder);
        int positionStart = this.hasEndStatusView() ? this.mViewCount - 1 : this.mViewCount;
        if (positionStart >= 0) {
            this.mViewHolderManager.putViewType(positionStart, viewType);
            ++this.mViewCount;
            this.notifyItemRangeInserted(positionStart, 1);
        }
    }

    public <T> void addAll(Class<? extends BaseViewHolder<T>> viewHolder, T[] data) {
        this.addAll(viewHolder, Arrays.asList(data));
    }

    public <T> void addAll(Class<? extends BaseViewHolder<T>> viewHolder, List<T> data) {
        if (this.mIsNoMoring || data == null || data.size() == 0) {
            return;
        }
        this.mIsLoadMoring = false;
        int size = data.size();
        this.mViewsData.addAll(data);
        this.mViewHolderManager.addViewHolder(viewHolder);
        int viewType = this.mViewHolderManager.getViewType(viewHolder);
        int positionStart = this.hasEndStatusView() ? this.mViewCount - 1 : this.mViewCount;
        if (positionStart >= 0) {
            for (int i = 0; i < size; ++i) {
                this.mViewHolderManager.putViewType(positionStart + i, viewType);
            }
            this.mViewCount += size;
            this.notifyItemRangeInserted(positionStart, size);
        }
    }

    @Override
    public void clear() {
        if (this.mViewsData == null) {
            this.log("clear() mData is null");
            return;
        }
        this.mViewsData.clear();
        this.mViewCount = this.hasEndStatusView() ? 1 : 0;
        this.mIsNoMoring = false;
        this.mIsLoadMoring = false;
        this.setViewVisible(this.mLoadMoreLayout, false);
        this.setViewVisible((View)this.mNoMoreView, false);
        this.notifyDataSetChanged();
    }
}

