/*
 * Decompiled with CFR 0.152.
 */
package cn.lemon.view.adapter;

import android.content.Context;
import android.support.annotation.IdRes;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public class BaseViewHolder<T>
extends RecyclerView.ViewHolder {
    private final String TAG = "BaseViewHolder";
    private T mData;

    public BaseViewHolder(ViewGroup parent, int layoutId) {
        this(LayoutInflater.from((Context)parent.getContext()).inflate(layoutId, parent, false));
    }

    public BaseViewHolder(View itemView) {
        super(itemView);
        this.onInitializeView();
        itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BaseViewHolder.this.onItemViewClick(BaseViewHolder.this.mData);
            }
        });
    }

    public void onInitializeView() {
    }

    public <T extends View> T findViewById(@IdRes int resId) {
        if (this.itemView != null) {
            return (T)this.itemView.findViewById(resId);
        }
        return null;
    }

    public void setData(T data) {
        if (data == null) {
            return;
        }
        this.mData = data;
    }

    public T getData() {
        return this.mData;
    }

    public void onItemViewClick(T data) {
    }
}

