/*
 * Decompiled with CFR 0.152.
 */
package cn.lemon.view.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import cn.lemon.view.adapter.BaseViewHolder;
import cn.lemon.view.adapter.IViewHolderFactory;
import cn.lemon.view.adapter.RecyclerAdapter;
import cn.lemon.view.adapter.ViewTypeManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CustomMultiTypeAdapter
extends RecyclerAdapter {
    private final String TAG = "CustomMultiTypeAdapter";
    private List<Object> mViewsData = new ArrayList<Object>();
    private ViewTypeManager mViewHolderManager = new ViewTypeManager();

    public CustomMultiTypeAdapter(Context context) {
        super(context);
    }

    public void setViewHolderFactory(IViewHolderFactory factory) {
        if (factory == null) {
            return;
        }
        this.mViewHolderManager.setViewHolderFactory(factory);
    }

    @Override
    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 333) {
            return new BaseViewHolder(this.mStatusView);
        }
        return this.mViewHolderManager.getViewHolder(parent, viewType);
    }

    public BaseViewHolder onCreateBaseViewHolder(ViewGroup parent, int viewType) {
        return null;
    }

    public void onBindViewHolder(BaseViewHolder holder, int position) {
        if (!this.mIsNoMoring && this.mLoadMoreEnable && !this.mIsLoadMoring && this.isValidLoadMore(position)) {
            this.mIsLoadMoring = true;
            this.setViewVisible(this.mLoadMoreLayout, true);
            this.setViewVisible(this.mLoadMoreView, true);
            this.setViewVisible((View)this.mLoadMoreError, false);
            this.setViewVisible((View)this.mNoMoreView, false);
            if (this.mLoadMoreAction != null) {
                this.log("load more");
                this.mLoadMoreAction.onAction();
            }
        } else if (position < this.mViewsData.size()) {
            holder.setData(this.mViewsData.get(position));
        }
    }

    @Override
    public int getItemViewType(int position) {
        if (this.hasEndStatusView() && position == this.mViewCount - 1) {
            return 333;
        }
        return this.mViewHolderManager.getViewType(position);
    }

    public void add(int viewType) {
        this.add(new Object(), viewType);
    }

    public <T> void add(T data, int viewType) {
        if (this.mIsNoMoring || data == null) {
            return;
        }
        this.mIsLoadMoring = false;
        this.mViewsData.add(data);
        int positionStart = this.hasEndStatusView() ? this.mViewCount - 1 : this.mViewCount;
        this.mViewHolderManager.putViewType(positionStart, viewType);
        ++this.mViewCount;
        this.notifyItemRangeInserted(positionStart, 1);
    }

    public <T> void addAll(T[] data, int viewType) {
        this.addAll(Arrays.asList(data), viewType);
    }

    public <T> void addAll(List<T> data, int viewType) {
        if (this.mIsNoMoring || data == null || data.size() == 0) {
            return;
        }
        this.mIsLoadMoring = false;
        int size = data.size();
        this.mViewsData.addAll(data);
        int positionStart = this.hasEndStatusView() ? this.mViewCount - 1 : this.mViewCount;
        for (int i = 0; i < size; ++i) {
            this.mViewHolderManager.putViewType(positionStart + i, viewType);
        }
        this.mViewCount += size;
        this.notifyItemRangeInserted(positionStart, size);
    }

    @Override
    public void clear() {
        if (this.mViewsData == null) {
            return;
        }
        this.mViewsData.clear();
        this.mViewCount = this.hasEndStatusView() ? 1 : 0;
        this.mIsNoMoring = false;
        this.mIsLoadMoring = false;
        this.setViewVisible(this.mLoadMoreLayout, false);
        this.setViewVisible((View)this.mNoMoreView, false);
        this.notifyDataSetChanged();
    }
}

