/*
 * Decompiled with CFR 0.152.
 */
package cn.lemon.view.adapter;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import cn.lemon.view.R;
import cn.lemon.view.adapter.Action;
import cn.lemon.view.adapter.BaseViewHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class RecyclerAdapter<T>
extends RecyclerView.Adapter<BaseViewHolder<T>> {
    private static final String TAG = "RecyclerAdapter";
    private boolean allowLog = true;
    public static final int HEADER_TYPE = 111;
    public static final int FOOTER_TYPE = 222;
    public static final int STATUS_TYPE = 333;
    int mViewCount = 0;
    private boolean hasHeader = false;
    private boolean hasFooter = false;
    protected boolean mLoadMoreEnable = false;
    protected boolean mShowNoMoreEnable = false;
    protected boolean mIsShowNoMoring = false;
    protected Action mLoadMoreAction;
    private List<T> mData = new ArrayList<T>();
    private View headerView;
    private View footerView;
    protected View mStatusView;
    protected LinearLayout mLoadMoreView;
    public TextView mNoMoreView;
    protected Context mContext;

    public void colseLog() {
        this.allowLog = false;
    }

    public RecyclerAdapter(Context context) {
        this.mContext = context;
    }

    public RecyclerAdapter(Context context, T[] data) {
        this(context, Arrays.asList(data));
    }

    public RecyclerAdapter(Context context, List<T> data) {
        this.mContext = context;
        this.mData = data;
        this.mViewCount += data.size();
        this.notifyDataSetChanged();
    }

    private void initEndStatusView() {
        if (this.isHasEndStatusView() && this.mStatusView == null) {
            this.mStatusView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_status_last, null);
            this.mStatusView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
            this.mLoadMoreView = (LinearLayout)this.mStatusView.findViewById(R.id.load_more_view);
            this.mNoMoreView = (TextView)this.mStatusView.findViewById(R.id.no_more_view);
            ++this.mViewCount;
        }
    }

    public void setLoadMoreEnable(boolean b) {
        this.mLoadMoreEnable = b;
        this.initEndStatusView();
    }

    public void setShowNoMoreEnable(boolean b) {
        this.mShowNoMoreEnable = b;
        this.initEndStatusView();
    }

    public boolean isShowNoMoring() {
        return this.mIsShowNoMoring;
    }

    public void setIsShowNoMoring(boolean b) {
        this.mIsShowNoMoring = b;
    }

    public BaseViewHolder<T> onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 111) {
            return new BaseViewHolder(this.headerView);
        }
        if (viewType == 222) {
            return new BaseViewHolder(this.footerView);
        }
        if (viewType == 333) {
            return new BaseViewHolder(this.mStatusView);
        }
        return this.onCreateBaseViewHolder(parent, viewType);
    }

    public abstract BaseViewHolder<T> onCreateBaseViewHolder(ViewGroup var1, int var2);

    public void onBindViewHolder(BaseViewHolder<T> holder, int position) {
        this.log("onBindViewHolder()  viewCount : " + this.mViewCount + " position : " + position);
        if (holder == null || position < 0) {
            return;
        }
        int dataSize = this.mData.size();
        if (position == 0) {
            if (this.mViewCount == 1 && (this.isHasEndStatusView() || this.hasHeader)) {
                return;
            }
            if (dataSize > 0) {
                holder.setData(this.mData.get(0));
            }
        } else if (this.isHasEndStatusView()) {
            if (!this.hasHeader && !this.hasFooter && position < dataSize) {
                holder.setData(this.mData.get(position));
            } else if (this.hasHeader && !this.hasFooter && position > 0 && position < this.mViewCount - 1 && position - 1 < dataSize) {
                holder.setData(this.mData.get(position - 1));
            } else if (!this.hasHeader && position < this.mViewCount - 2 && position < dataSize) {
                holder.setData(this.mData.get(position));
            } else if (position > 0 && position < this.mViewCount - 2 && position - 1 < dataSize) {
                holder.setData(this.mData.get(position - 1));
            }
        } else if (!this.hasHeader && !this.hasFooter && position < dataSize) {
            holder.setData(this.mData.get(position));
        } else if (this.hasHeader && !this.hasFooter && position > 0 && position < this.mViewCount && position - 1 < dataSize) {
            holder.setData(this.mData.get(position - 1));
        } else if (!this.hasHeader && position < this.mViewCount - 1 && position < dataSize) {
            holder.setData(this.mData.get(position));
        } else if (position > 0 && position < this.mViewCount - 1 && position - 1 < dataSize) {
            holder.setData(this.mData.get(position - 1));
        }
        if (this.mLoadMoreEnable && !this.mIsShowNoMoring && position == this.mViewCount - 2) {
            this.setViewVisible((View)this.mLoadMoreView, true);
            if (this.mLoadMoreAction != null) {
                this.mLoadMoreAction.onAction();
            }
        }
    }

    public int getItemViewType(int position) {
        if (this.hasHeader && position == 0) {
            return 111;
        }
        if (this.hasFooter && this.isHasEndStatusView() && position == this.mViewCount - 2) {
            return 222;
        }
        if (this.hasFooter && !this.isHasEndStatusView() && position == this.mViewCount - 1) {
            return 222;
        }
        if (this.isHasEndStatusView() && position == this.mViewCount - 1) {
            return 333;
        }
        return super.getItemViewType(position);
    }

    public int getItemCount() {
        return this.mViewCount;
    }

    public void showNoMore() {
        if (!this.mShowNoMoreEnable) {
            return;
        }
        this.mIsShowNoMoring = true;
        if (this.mLoadMoreView != null) {
            this.mLoadMoreView.post(new Runnable(){

                @Override
                public void run() {
                    RecyclerAdapter.this.setViewVisible((View)RecyclerAdapter.this.mLoadMoreView, false);
                    RecyclerAdapter.this.setViewVisible((View)RecyclerAdapter.this.mNoMoreView, true);
                }
            });
        }
    }

    public void openLoadMore() {
        this.mIsShowNoMoring = false;
        if (this.mLoadMoreView != null) {
            this.mLoadMoreView.post(new Runnable(){

                @Override
                public void run() {
                    RecyclerAdapter.this.setViewVisible((View)RecyclerAdapter.this.mLoadMoreView, true);
                    RecyclerAdapter.this.setViewVisible((View)RecyclerAdapter.this.mNoMoreView, false);
                }
            });
        }
    }

    public void setLoadMoreAction(Action action) {
        this.mLoadMoreAction = action;
    }

    public void add(T object) {
        if (!this.mIsShowNoMoring && object != null) {
            this.mData.add(object);
            int position = this.hasFooter && this.isHasEndStatusView() ? this.mViewCount - 2 : (this.hasFooter && !this.isHasEndStatusView() ? this.mViewCount - 1 : (!this.hasFooter && this.isHasEndStatusView() ? this.mViewCount - 1 : this.mViewCount));
            ++this.mViewCount;
            this.notifyItemInserted(position);
        }
    }

    public void insert(T object, int itemPosition) {
        int maxPosition;
        int n = maxPosition = this.isHasEndStatusView() ? this.mViewCount - 2 : this.mViewCount - 1;
        if (this.mData != null && itemPosition < maxPosition && object != null) {
            int dataPosition = this.hasHeader ? itemPosition - 1 : itemPosition;
            this.mData.add(dataPosition, object);
            ++this.mViewCount;
            this.notifyItemInserted(itemPosition);
        }
    }

    public void addAll(List<T> data) {
        if (data == null) {
            return;
        }
        int size = data.size();
        if (!this.mIsShowNoMoring && size > 0) {
            this.mData.addAll(data);
            int positionStart = this.hasFooter && this.isHasEndStatusView() ? this.mViewCount - 2 : (this.hasFooter && !this.isHasEndStatusView() ? this.mViewCount - 1 : (!this.hasFooter && this.isHasEndStatusView() ? this.mViewCount - 1 : this.mViewCount));
            this.mViewCount += size;
            this.notifyItemRangeInserted(positionStart, size);
            this.log("addAll()  startPosition : " + positionStart + "  itemCount : " + size);
        }
    }

    public void addAll(T[] objects) {
        this.addAll(Arrays.asList(objects));
    }

    public void replace(T object, int itemPosition) {
        int dataPosition;
        if (this.mData != null && object != null && (dataPosition = this.hasHeader ? itemPosition - 1 : itemPosition) < this.mData.size()) {
            this.mData.set(dataPosition, object);
            ++this.mViewCount;
            this.notifyItemChanged(itemPosition);
        }
    }

    public void remove(T object) {
        if (object != null && !this.mData.contains(object)) {
            Toast.makeText((Context)this.getContext(), (CharSequence)"\u5220\u9664\u5931\u8d25", (int)0).show();
            this.log("remove()  without the object : " + object.getClass().getName());
            return;
        }
        int dataPosition = this.mData.indexOf(object);
        int itemPosition = this.hasHeader ? dataPosition + 1 : dataPosition;
        this.remove(itemPosition);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove(int itemPosition) {
        int dataSize = this.mData.size();
        if (this.hasHeader) {
            int dataPosition = itemPosition - 1;
            if (dataPosition >= 0 && dataPosition < dataSize) {
                this.mData.remove(dataPosition);
                this.notifyItemRemoved(itemPosition);
                --this.mViewCount;
                return;
            } else {
                if (dataPosition < dataSize) throw new IndexOutOfBoundsException("RecyclerView has header,position is should more than 0 .if you want remove header , pleasure user removeHeader()");
                Toast.makeText((Context)this.getContext(), (CharSequence)"\u5220\u9664\u5931\u8d25", (int)0).show();
            }
            return;
        } else {
            int dataPosition = itemPosition;
            if (dataPosition >= dataSize) {
                Toast.makeText((Context)this.getContext(), (CharSequence)"\u5220\u9664\u5931\u8d25", (int)0).show();
                return;
            } else {
                this.mData.remove(dataPosition);
                this.notifyItemRemoved(itemPosition);
                --this.mViewCount;
            }
        }
    }

    public void clear() {
        if (this.mData == null) {
            this.log("clear() mData is null");
            return;
        }
        this.mData.clear();
        int n = this.mViewCount = this.isHasEndStatusView() ? 1 : 0;
        if (this.hasHeader) {
            ++this.mViewCount;
        }
        if (this.hasFooter) {
            ++this.mViewCount;
        }
        this.mIsShowNoMoring = false;
        this.setViewVisible((View)this.mLoadMoreView, false);
        this.setViewVisible((View)this.mNoMoreView, false);
        this.notifyDataSetChanged();
    }

    public void setHeader(View header) {
        this.hasHeader = true;
        this.headerView = header;
        ++this.mViewCount;
    }

    public void setHeader(@LayoutRes int res) {
        this.setHeader(LayoutInflater.from((Context)this.mContext).inflate(res, null));
    }

    public View getHeader() {
        return this.headerView;
    }

    public View getFooter() {
        return this.footerView;
    }

    public void setFooter(View footer) {
        this.hasFooter = true;
        this.footerView = footer;
        ++this.mViewCount;
    }

    public void setFooter(@LayoutRes int res) {
        this.setFooter(LayoutInflater.from((Context)this.mContext).inflate(res, null));
    }

    public void removeHeader() {
        if (this.hasHeader) {
            this.hasHeader = false;
            this.notifyItemRemoved(0);
        }
    }

    public void removeFooter() {
        if (this.hasFooter) {
            this.hasFooter = false;
            if (this.isHasEndStatusView() && this.mViewCount > 1) {
                this.notifyItemRemoved(this.mViewCount - 2);
            } else if (!this.isHasEndStatusView() && this.mViewCount > 0) {
                this.notifyItemRemoved(this.mViewCount - 1);
            }
        }
    }

    public List<T> getData() {
        return this.mData;
    }

    public Context getContext() {
        return this.mContext;
    }

    protected void setViewVisible(View view, boolean visibile) {
        if (view != null) {
            view.setVisibility(visibile ? 0 : 8);
        }
    }

    protected boolean isHasEndStatusView() {
        return this.mLoadMoreEnable || this.mShowNoMoreEnable;
    }

    public void log(String content) {
        if (this.allowLog) {
            Log.d((String)TAG, (String)content);
        }
    }
}

