/*
 * Decompiled with CFR 0.152.
 */
package cn.lemon.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import cn.lemon.view.R;
import cn.lemon.view.SpaceItemDecoration;
import cn.lemon.view.adapter.Action;
import cn.lemon.view.adapter.RecyclerAdapter;
import java.util.ArrayList;
import java.util.List;

public class RefreshRecyclerView
extends FrameLayout
implements SwipeRefreshLayout.OnRefreshListener {
    private final String TAG = "RefreshRecyclerView";
    private SwipeRefreshLayout mSwipeRefreshLayout;
    private RecyclerView mRecyclerView;
    private RecyclerAdapter mAdapter;
    private List<Action> mRefreshActions;
    private boolean mLoadMoreEnable;
    private boolean mShowNoMoreEnable;

    public RefreshRecyclerView(Context context) {
        this(context, null);
    }

    public RefreshRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RefreshRecyclerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View view = RefreshRecyclerView.inflate((Context)context, (int)R.layout.view_refresh_recycler, (ViewGroup)this);
        this.mRecyclerView = (RecyclerView)view.findViewById(R.id.lemon_recycler_view);
        this.mSwipeRefreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.lemon_refresh_layout);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RefreshRecyclerView);
        this.mLoadMoreEnable = typedArray.getBoolean(R.styleable.RefreshRecyclerView_load_more_enable, true);
        this.mShowNoMoreEnable = typedArray.getBoolean(R.styleable.RefreshRecyclerView_show_no_more_enable, true);
        boolean refreshEnable = typedArray.getBoolean(R.styleable.RefreshRecyclerView_refresh_enable, true);
        if (!refreshEnable) {
            this.mSwipeRefreshLayout.setEnabled(false);
        } else {
            this.mSwipeRefreshLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        }
        typedArray.recycle();
    }

    public void setAdapter(RecyclerAdapter adapter) {
        if (adapter == null) {
            return;
        }
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)adapter);
        this.mAdapter = adapter;
        this.mAdapter.setLoadMoreEnable(this.mLoadMoreEnable);
        this.mAdapter.setShowNoMoreEnable(this.mShowNoMoreEnable);
    }

    public void setLayoutManager(final RecyclerView.LayoutManager layoutManager) {
        this.mRecyclerView.setLayoutManager(layoutManager);
        if (layoutManager instanceof GridLayoutManager) {
            ((GridLayoutManager)layoutManager).setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    int type = RefreshRecyclerView.this.mAdapter.getItemViewType(position);
                    if (type == 111 || type == 222 || type == 333) {
                        return ((GridLayoutManager)layoutManager).getSpanCount();
                    }
                    return 1;
                }
            });
        }
    }

    public void addRefreshAction(Action action) {
        if (action == null) {
            return;
        }
        if (this.mRefreshActions == null) {
            this.mRefreshActions = new ArrayList<Action>();
        }
        this.mRefreshActions.add(action);
    }

    public void setLoadMoreAction(Action action) {
        Log.d((String)"RefreshRecyclerView", (String)"setLoadMoreAction");
        if (this.mAdapter.isShowNoMoring() || !this.mLoadMoreEnable) {
            return;
        }
        this.mAdapter.setIsShowNoMoring(true);
        this.mAdapter.setLoadMoreAction(action);
    }

    public void showNoMore() {
        this.mAdapter.showNoMore();
    }

    public void setItemSpace(int left, int top, int right, int bottom) {
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new SpaceItemDecoration(left, top, right, bottom));
    }

    public void addItemDecoration(RecyclerView.ItemDecoration itemDecoration) {
        this.mRecyclerView.addItemDecoration(itemDecoration);
    }

    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    public SwipeRefreshLayout getSwipeRefreshLayout() {
        return this.mSwipeRefreshLayout;
    }

    public TextView getNoMoreView() {
        return this.mAdapter.mNoMoreView;
    }

    public void setSwipeRefreshColorsFromRes(int ... colors) {
        this.mSwipeRefreshLayout.setColorSchemeResources(colors);
    }

    public void setSwipeRefreshColors(int ... colors) {
        this.mSwipeRefreshLayout.setColorSchemeColors(colors);
    }

    public void showSwipeRefresh() {
        this.mSwipeRefreshLayout.setRefreshing(true);
    }

    public void dismissSwipeRefresh() {
        this.mSwipeRefreshLayout.setRefreshing(false);
    }

    public void onRefresh() {
        for (Action a : this.mRefreshActions) {
            a.onAction();
        }
    }
}

