/*
 * Decompiled with CFR 0.152.
 */
package cn.lemon.view.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import cn.lemon.view.adapter.BaseViewHolder;
import cn.lemon.view.adapter.IViewHolderFactory;
import cn.lemon.view.adapter.RecyclerAdapter;
import cn.lemon.view.adapter.ViewTypeManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CustomMultiTypeAdapter
extends RecyclerAdapter {
    private final String TAG = "CustomMultiTypeAdapter";
    private List<Object> mViewsData = new ArrayList<Object>();
    private ViewTypeManager mViewHolderManager = new ViewTypeManager();

    public CustomMultiTypeAdapter(Context context) {
        super(context);
    }

    public void setViewHolderFactory(IViewHolderFactory factory) {
        if (factory == null) {
            return;
        }
        this.mViewHolderManager.setViewHolderFactory(factory);
    }

    @Override
    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 333) {
            return new BaseViewHolder(this.mStatusView);
        }
        return this.mViewHolderManager.getViewHolder(parent, viewType);
    }

    public BaseViewHolder onCreateBaseViewHolder(ViewGroup parent, int viewType) {
        return null;
    }

    public void onBindViewHolder(BaseViewHolder holder, int position) {
        if (position == 0 && this.mViewCount == 1) {
            return;
        }
        if (position == this.mViewCount - 1) {
            if (this.loadMoreEnable && this.mLoadMoreAction != null && !this.dismissLoadMore) {
                this.setViewVisible((View)this.mLoadMoreView, true);
                this.mLoadMoreAction.onAction();
            }
        } else {
            holder.setData(this.mViewsData.get(position));
        }
    }

    @Override
    public int getItemViewType(int position) {
        if (position == this.mViewCount - 1) {
            return 333;
        }
        return this.mViewHolderManager.getViewType(position);
    }

    public <T> void add(T data, int viewType) {
        if (this.dismissLoadMore && data == null) {
            return;
        }
        this.mViewsData.add(data);
        this.mViewHolderManager.putViewType(this.mViewCount - 1, viewType);
        int positionStart = this.mViewCount - 1;
        ++this.mViewCount;
        this.notifyItemRangeInserted(positionStart, 1);
    }

    public <T> void addAll(T[] data, int viewType) {
        this.addAll(Arrays.asList(data), viewType);
    }

    public <T> void addAll(List<T> data, int viewType) {
        if (this.dismissLoadMore || data == null || data.size() == 0) {
            return;
        }
        int size = data.size();
        this.mViewsData.addAll(data);
        int positionStart = this.mViewCount - 1;
        for (int i = 0; i < size; ++i) {
            this.mViewHolderManager.putViewType(this.mViewCount - 1, viewType);
            ++this.mViewCount;
        }
        this.notifyItemRangeInserted(positionStart, size);
    }

    @Override
    public void clear() {
        if (this.mViewsData == null) {
            return;
        }
        this.mViewsData.clear();
        this.mViewCount = 1;
        this.dismissLoadMore = false;
        this.setViewVisible((View)this.mLoadMoreView, false);
        this.setViewVisible((View)this.mNoMoreView, false);
        this.notifyDataSetChanged();
    }
}

