/*
 * Decompiled with CFR 0.152.
 */
package cn.lemon.view.adapter;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import cn.lemon.view.adapter.BaseViewHolder;
import cn.lemon.view.adapter.RecyclerAdapter;
import cn.lemon.view.adapter.ViewHolderManager;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultiTypeAdapter
extends RecyclerAdapter {
    private final String TAG = "MultiTypeAdapter";
    private List<Object> mViewsData = new ArrayList<Object>();
    private ViewHolderManager mViewHolderManager = new ViewHolderManager();

    public MultiTypeAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewType(int position) {
        if (position == this.mViewCount - 1) {
            return 333;
        }
        return this.mViewHolderManager.getViewType(position);
    }

    @Override
    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        this.log("onCreateViewHolder -- viewType : " + viewType);
        if (this.mViewHolderManager == null) {
            throw new ExceptionInInitializerError("mViewHolderManager is null , it need init");
        }
        Class<? extends BaseViewHolder> clazzViewHolder = this.mViewHolderManager.getViewHolderClass(viewType);
        try {
            Constructor<? extends BaseViewHolder> constructor = clazzViewHolder.getDeclaredConstructor(ViewGroup.class);
            constructor.setAccessible(true);
            BaseViewHolder holder = constructor.newInstance(parent);
            if (holder == null) {
                constructor = clazzViewHolder.getDeclaredConstructor(new Class[0]);
                holder = constructor.newInstance(new Object[0]);
            }
            return holder;
        }
        catch (Exception e) {
            Log.e((String)"MultiTypeAdapter", (String)("onCreateBaseViewHolder : " + e.getMessage()));
            return null;
        }
    }

    public BaseViewHolder onCreateBaseViewHolder(ViewGroup parent, int viewType) {
        return null;
    }

    public void onBindViewHolder(BaseViewHolder holder, int position) {
        this.log("onBindViewHolder -- position : " + position);
        if (position == 0 && this.mViewCount == 1) {
            return;
        }
        if (position == this.mViewCount - 1 && this.mLoadMoreView != null) {
            if (this.loadMoreEnable && this.mLoadMoreAction != null && !this.dismissLoadMore) {
                this.setViewVisible((View)this.mLoadMoreView, true);
                this.mLoadMoreAction.onAction();
            }
        } else if (this.mViewsData != null && holder != null) {
            holder.setData(this.mViewsData.get(position));
        }
    }

    public <T> void add(Class<? extends BaseViewHolder<T>> viewHolder, T data) {
        if (this.dismissLoadMore || data == null || viewHolder == null) {
            return;
        }
        this.mViewsData.add(data);
        this.mViewHolderManager.addViewHolder(viewHolder);
        int viewType = this.mViewHolderManager.getViewType(viewHolder);
        this.mViewHolderManager.putViewType(this.mViewCount - 1, viewType);
        if (this.mViewCount > 0) {
            int positionStart = this.mViewCount - 1;
            ++this.mViewCount;
            this.notifyItemRangeInserted(positionStart, 1);
        }
    }

    public <T> void addAll(Class<? extends BaseViewHolder<T>> viewHolder, T[] data) {
        this.addAll(viewHolder, Arrays.asList(data));
    }

    public <T> void addAll(Class<? extends BaseViewHolder<T>> viewHolder, List<T> data) {
        if (this.dismissLoadMore || data == null || data.size() == 0) {
            return;
        }
        int size = data.size();
        this.mViewsData.addAll(data);
        this.mViewHolderManager.addViewHolder(viewHolder);
        int viewType = this.mViewHolderManager.getViewType(viewHolder);
        if (this.mViewCount > 0) {
            int positionStart = this.mViewCount - 1;
            for (int i = 0; i < size; ++i) {
                this.mViewHolderManager.putViewType(this.mViewCount - 1, viewType);
                ++this.mViewCount;
            }
            this.notifyItemRangeInserted(positionStart, size);
        }
    }

    @Override
    public void clear() {
        if (this.mViewsData == null) {
            this.log("clear() mData is null");
            return;
        }
        this.mViewsData.clear();
        this.mViewCount = 1;
        this.dismissLoadMore = false;
        this.setViewVisible((View)this.mLoadMoreView, false);
        this.setViewVisible((View)this.mNoMoreView, false);
        this.notifyDataSetChanged();
    }
}

