/*
 * Decompiled with CFR 0.152.
 */
package cn.lemon.view.adapter;

import android.content.Context;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.ViewGroup;
import cn.lemon.view.adapter.BaseViewHolder;
import cn.lemon.view.adapter.RecyclerAdapter;
import cn.lemon.view.adapter.ViewHolderManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultiTypeAdapter
extends RecyclerAdapter {
    private final String TAG = "MultiTypeAdapter";
    private List<Object> mViewsData = new ArrayList<Object>();
    private SparseIntArray mPositionViewType = new SparseIntArray();
    private ViewHolderManager mViewHolderManager = new ViewHolderManager();

    public MultiTypeAdapter(Context context) {
        super(context);
    }

    public <T> void add(Class<? extends BaseViewHolder<T>> viewHolder, T data) {
        if (this.isShowNoMore) {
            return;
        }
        this.mViewsData.add(data);
        this.mViewHolderManager.addViewHolder(viewHolder);
        int viewType = this.mViewHolderManager.getViewType(viewHolder);
        this.mPositionViewType.put(this.mViewCount - 1, viewType);
        int positionStart = this.mViewCount - 1;
        ++this.mViewCount;
        this.notifyItemRangeInserted(positionStart, 1);
    }

    public <T> void addAll(Class<? extends BaseViewHolder<T>> viewHolder, T[] data) {
        this.addAll(viewHolder, Arrays.asList(data));
    }

    public <T> void addAll(Class<? extends BaseViewHolder<T>> viewHolder, List<T> data) {
        int size = data.size();
        if (this.isShowNoMore || size == 0) {
            return;
        }
        this.mViewsData.addAll(data);
        this.mViewHolderManager.addViewHolder(viewHolder);
        int viewType = this.mViewHolderManager.getViewType(viewHolder);
        int positionStart = this.mViewCount - 1;
        for (int i = 0; i < size; ++i) {
            this.mPositionViewType.put(this.mViewCount - 1, viewType);
            ++this.mViewCount;
        }
        this.notifyItemRangeInserted(positionStart, size);
    }

    @Override
    public void clear() {
        if (this.mViewsData == null) {
            this.log("clear() mData is null");
            return;
        }
        this.mViewsData.clear();
        this.mViewCount = 1;
        this.isShowNoMore = false;
        this.mLoadMoreView.setVisibility(8);
        this.mNoMoreView.setVisibility(8);
        this.notifyDataSetChanged();
    }

    @Override
    public int getItemViewType(int position) {
        if (position == this.mViewCount - 1) {
            return 333;
        }
        return this.mPositionViewType.get(position);
    }

    @Override
    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        this.log("onCreateViewHolder -- viewType : " + viewType);
        if (viewType == 333) {
            return new BaseViewHolder(this.mStatusView);
        }
        Class<? extends BaseViewHolder> clazzViewHolder = this.mViewHolderManager.getViewHolder(viewType);
        try {
            Constructor<? extends BaseViewHolder> constructor = clazzViewHolder.getDeclaredConstructor(ViewGroup.class);
            constructor.setAccessible(true);
            BaseViewHolder holder = constructor.newInstance(parent);
            if (holder == null) {
                constructor = clazzViewHolder.getDeclaredConstructor(new Class[0]);
                holder = constructor.newInstance(new Object[0]);
            }
            return holder;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            Log.e((String)"MultiTypeAdapter", (String)("onCreateBaseViewHolder : " + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            Log.e((String)"MultiTypeAdapter", (String)("onCreateBaseViewHolder : " + e.getMessage()));
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            Log.e((String)"MultiTypeAdapter", (String)("onCreateBaseViewHolder : " + e.getMessage()));
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            Log.e((String)"MultiTypeAdapter", (String)("onCreateBaseViewHolder : " + e.getMessage()));
        }
        return null;
    }

    public BaseViewHolder onCreateBaseViewHolder(ViewGroup parent, int viewType) {
        return null;
    }

    public void onBindViewHolder(BaseViewHolder holder, int position) {
        this.log("onBindViewHolder -- position : " + position);
        if (position != 0 || this.mViewCount != 1) {
            if (position == this.mViewCount - 1) {
                if (this.loadMoreAble && this.mLoadMoreAction != null && !this.isShowNoMore) {
                    this.mLoadMoreView.setVisibility(0);
                    this.mLoadMoreAction.onAction();
                }
            } else {
                holder.setData(this.mViewsData.get(position));
            }
        }
    }
}

