/*
 * Decompiled with CFR 0.152.
 */
package cn.lemon.view.adapter;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.lemon.view.R;
import cn.lemon.view.adapter.Action;
import cn.lemon.view.adapter.BaseViewHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class RecyclerAdapter<T>
extends RecyclerView.Adapter<BaseViewHolder<T>> {
    private static final String TAG = "RecyclerAdapter";
    private boolean allowLog = true;
    private static final int HEADER_TYPE = 111;
    private static final int FOOTER_TYPE = 222;
    protected static final int STATUS_TYPE = 333;
    protected int mViewCount = 0;
    private boolean hasHeader = false;
    private boolean hasFooter = false;
    public boolean isRefreshing = false;
    public boolean isLoadingMore = false;
    public boolean isShowNoMore = false;
    public boolean isLoadEnd = false;
    public boolean loadMoreAble = false;
    protected Action mLoadMoreAction;
    private List<T> mData = new ArrayList<T>();
    private View headerView;
    private View footerView;
    protected View mStatusView;
    protected LinearLayout mLoadMoreView;
    public TextView mNoMoreView;
    private Context mContext;

    public void colseLog() {
        this.allowLog = false;
    }

    public RecyclerAdapter(Context context) {
        this.mContext = context;
        this.initStatusView(context);
    }

    public RecyclerAdapter(Context context, T[] data) {
        this(context, Arrays.asList(data));
    }

    public RecyclerAdapter(Context context, List<T> data) {
        this.mContext = context;
        this.initStatusView(context);
        this.mData = data;
        this.mViewCount += data.size();
        this.notifyDataSetChanged();
    }

    public void initStatusView(Context context) {
        this.mStatusView = LayoutInflater.from((Context)context).inflate(R.layout.view_status_last, null);
        this.mStatusView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        this.mLoadMoreView = (LinearLayout)this.mStatusView.findViewById(R.id.load_more_view);
        this.mNoMoreView = (TextView)this.mStatusView.findViewById(R.id.no_more_view);
        ++this.mViewCount;
    }

    public BaseViewHolder<T> onCreateViewHolder(ViewGroup parent, int viewType) {
        this.log("onCreateViewHolder -- viewType : " + viewType);
        if (viewType == 111) {
            return new BaseViewHolder(this.headerView);
        }
        if (viewType == 222) {
            return new BaseViewHolder(this.footerView);
        }
        if (viewType == 333) {
            return new BaseViewHolder(this.mStatusView);
        }
        return this.onCreateBaseViewHolder(parent, viewType);
    }

    public abstract BaseViewHolder<T> onCreateBaseViewHolder(ViewGroup var1, int var2);

    public void onBindViewHolder(BaseViewHolder<T> holder, int position) {
        this.log("onBindViewHolder -- position : " + position);
        if (position == this.mViewCount - 1) {
            return;
        }
        if (!this.hasHeader && !this.hasFooter && position < this.mData.size()) {
            holder.setData(this.mData.get(position));
        } else if (this.hasHeader && !this.hasFooter && position > 0 && position < this.mViewCount - 1) {
            holder.setData(this.mData.get(position - 1));
        } else if (!this.hasHeader && position < this.mViewCount - 2) {
            holder.setData(this.mData.get(position));
        } else if (position > 0 && position < this.mViewCount - 2) {
            holder.setData(this.mData.get(position - 1));
        }
        if (this.loadMoreAble && position == this.mViewCount - 2 && !this.isShowNoMore) {
            if (this.hasHeader && !this.hasFooter && position != 0) {
                this.mLoadMoreView.setVisibility(0);
            } else if (this.hasFooter && !this.hasHeader && position != 0) {
                this.mLoadMoreView.setVisibility(0);
            } else if (!this.hasHeader && !this.hasFooter) {
                this.mLoadMoreView.setVisibility(0);
            } else if (this.hasHeader && this.hasFooter && position != 1) {
                this.mLoadMoreView.setVisibility(0);
            }
            this.isLoadEnd = true;
            if (this.mLoadMoreAction != null && !this.isLoadingMore && this.loadMoreAble) {
                this.mLoadMoreAction.onAction();
                this.isLoadingMore = true;
            }
        }
    }

    public int getItemViewType(int position) {
        this.log("getItemViewType --- position : " + position);
        if (this.hasHeader && position == 0) {
            return 111;
        }
        if (this.hasFooter && position == this.mViewCount - 2) {
            return 222;
        }
        if (position == this.mViewCount - 1) {
            return 333;
        }
        return super.getItemViewType(position);
    }

    public int getItemCount() {
        this.log("getItemCount : " + this.mViewCount);
        return this.mViewCount;
    }

    public void showNoMore() {
        this.isShowNoMore = true;
        this.mLoadMoreView.post(new Runnable(){

            @Override
            public void run() {
                RecyclerAdapter.this.mLoadMoreView.setVisibility(8);
                RecyclerAdapter.this.mNoMoreView.setVisibility(0);
            }
        });
    }

    public void openLoadMore() {
        this.isShowNoMore = false;
        this.mLoadMoreView.post(new Runnable(){

            @Override
            public void run() {
                RecyclerAdapter.this.mLoadMoreView.setVisibility(0);
                RecyclerAdapter.this.mNoMoreView.setVisibility(8);
            }
        });
    }

    public void setLoadMoreAction(Action action) {
        this.mLoadMoreAction = action;
    }

    public void add(T object) {
        if (!this.isShowNoMore) {
            this.isLoadingMore = false;
            this.mData.add(object);
            ++this.mViewCount;
            int position = this.mData.size();
            if (this.hasHeader) {
                ++position;
            }
            this.notifyItemInserted(position);
        }
    }

    public void insert(T object, int position) {
        if (!this.isShowNoMore) {
            this.isLoadingMore = false;
            this.mData.add(position, object);
            ++this.mViewCount;
            this.notifyItemInserted(position);
        }
    }

    public void addAll(List<T> data) {
        if (!this.isShowNoMore && data.size() > 0) {
            this.isLoadingMore = false;
            if (data.size() == 0) {
                return;
            }
            int startPosition = this.mData.size();
            if (this.hasHeader) {
                ++startPosition;
            }
            this.mData.addAll(data);
            if (this.mViewCount == 1 || this.hasHeader && this.mViewCount == 2) {
                this.mViewCount += data.size();
                this.notifyDataSetChanged();
            } else {
                this.mViewCount += data.size();
                this.notifyItemRangeInserted(startPosition, data.size());
            }
            this.log("addAll : startPosition : " + startPosition + "  itemCount : " + data.size());
        }
    }

    public void addAll(T[] objects) {
        this.addAll(Arrays.asList(objects));
    }

    public void replace(T object, int position) {
        this.isLoadingMore = false;
        this.mData.set(position, object);
        ++this.mViewCount;
        this.notifyItemChanged(position);
    }

    public void remove(T object) {
        if (!this.mData.contains(object)) {
            return;
        }
        this.isLoadingMore = false;
        int position = this.mData.indexOf(object);
        this.mData.remove(object);
        if (this.hasHeader) {
            this.notifyItemRemoved(position + 1);
        } else {
            this.notifyItemRemoved(position);
        }
        --this.mViewCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove(int position) {
        this.isLoadingMore = false;
        if (this.hasHeader) {
            if (position - 1 < 0) throw new IndexOutOfBoundsException("RecyclerView has header,position is should more than 0");
            this.mData.remove(position - 1);
            this.notifyItemRemoved(position);
        } else {
            this.mData.remove(position);
            this.notifyItemRemoved(position);
        }
        --this.mViewCount;
    }

    public void clear() {
        if (this.mData == null || this.mData.size() == 0) {
            return;
        }
        this.mData.clear();
        this.mViewCount = 1;
        if (this.hasHeader) {
            ++this.mViewCount;
        }
        if (this.hasFooter) {
            ++this.mViewCount;
        }
        this.notifyDataSetChanged();
        this.isRefreshing = false;
        this.isShowNoMore = false;
        this.isLoadingMore = false;
        this.mLoadMoreView.setVisibility(8);
        this.mNoMoreView.setVisibility(8);
    }

    public void setHeader(View header) {
        this.hasHeader = true;
        this.headerView = header;
        ++this.mViewCount;
    }

    public void setHeader(@LayoutRes int res) {
        this.setHeader(LayoutInflater.from((Context)this.mContext).inflate(res, null));
    }

    public View getHeader() {
        return this.headerView;
    }

    public View getFooter() {
        return this.footerView;
    }

    public void setFooter(View footer) {
        this.hasFooter = true;
        this.footerView = footer;
        ++this.mViewCount;
    }

    public void setFooter(@LayoutRes int res) {
        this.setFooter(LayoutInflater.from((Context)this.mContext).inflate(res, null));
    }

    public void removeHeader() {
        if (this.hasHeader) {
            this.hasHeader = false;
        }
    }

    public void removeFooter() {
        if (this.hasFooter) {
            this.hasFooter = false;
        }
    }

    public void log(String content) {
        if (this.allowLog) {
            Log.i((String)TAG, (String)content);
        }
    }
}

