/*
 * Decompiled with CFR 0.152.
 */
package cn.lemon.view.adapter;

import android.content.Context;
import android.util.Log;
import android.view.ViewGroup;
import cn.lemon.view.adapter.BaseViewHolder;
import cn.lemon.view.adapter.RecyclerAdapter;
import cn.lemon.view.adapter.ViewHolderManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiTypeAdapter
extends RecyclerAdapter {
    private final String TAG = "MultiTypeAdapter";
    private List<Object> mViewsData = new ArrayList<Object>();
    private Map<Integer, Integer> mPositionViewType = new HashMap<Integer, Integer>();
    private ViewHolderManager mViewHolderManager = new ViewHolderManager();

    public MultiTypeAdapter(Context context) {
        super(context);
    }

    public <T> void add(Class<? extends BaseViewHolder<T>> viewHolder, T data) {
        if (this.isShowNoMore) {
            return;
        }
        this.isLoadingMore = false;
        this.mViewsData.add(data);
        this.mViewHolderManager.addViewHolder(viewHolder);
        int viewType = this.mViewHolderManager.getViewType(viewHolder);
        this.mPositionViewType.put(this.mViewCount - 1, viewType);
        ++this.mViewCount;
        this.notifyDataSetChanged();
    }

    public <T> void addAll(Class<? extends BaseViewHolder<T>> viewHolder, T[] data) {
        this.addAll(viewHolder, Arrays.asList(data));
    }

    public <T> void addAll(Class<? extends BaseViewHolder<T>> viewHolder, List<T> data) {
        if (this.isShowNoMore) {
            return;
        }
        this.isLoadingMore = false;
        this.mViewsData.addAll(data);
        this.mViewHolderManager.addViewHolder(viewHolder);
        int viewType = this.mViewHolderManager.getViewType(viewHolder);
        for (int i = 0; i < data.size(); ++i) {
            this.mPositionViewType.put(this.mViewCount - 1, viewType);
            ++this.mViewCount;
        }
        this.notifyDataSetChanged();
    }

    @Override
    public void clear() {
        if (this.mViewsData == null || this.mViewsData.size() == 0) {
            return;
        }
        this.mViewsData.clear();
        this.mViewCount = 1;
        this.notifyDataSetChanged();
        this.isRefreshing = false;
        this.isShowNoMore = false;
        this.isLoadingMore = false;
        this.mLoadMoreView.setVisibility(8);
        this.mNoMoreView.setVisibility(8);
    }

    @Override
    public int getItemViewType(int position) {
        if (position == this.mViewCount - 1) {
            return 333;
        }
        return this.mPositionViewType.get(position);
    }

    @Override
    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        this.log("onCreateViewHolder -- viewType : " + viewType);
        if (viewType == 333) {
            return new BaseViewHolder(this.mStatusView);
        }
        Class<? extends BaseViewHolder> clazzViewHolder = this.mViewHolderManager.getViewHolder(viewType);
        try {
            Constructor<? extends BaseViewHolder> constructor = clazzViewHolder.getDeclaredConstructor(ViewGroup.class);
            constructor.setAccessible(true);
            return constructor.newInstance(parent);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            Log.i((String)"MultiTypeAdapter", (String)("onCreateBaseViewHolder : " + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            Log.i((String)"MultiTypeAdapter", (String)("onCreateBaseViewHolder : " + e.getMessage()));
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            Log.i((String)"MultiTypeAdapter", (String)("onCreateBaseViewHolder : " + e.getMessage()));
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            Log.i((String)"MultiTypeAdapter", (String)("onCreateBaseViewHolder : " + e.getMessage()));
        }
        return null;
    }

    public BaseViewHolder onCreateBaseViewHolder(ViewGroup parent, int viewType) {
        return null;
    }

    public void onBindViewHolder(BaseViewHolder holder, int position) {
        this.log("onBindViewHolder -- position : " + position);
        if (position == 0 && this.mViewCount == 1) {
            return;
        }
        if (position == this.mViewCount - 1) {
            this.isLoadEnd = true;
            if (this.loadMoreAble && this.mLoadMoreAction != null && !this.isShowNoMore && !this.isLoadingMore) {
                this.mLoadMoreView.setVisibility(0);
                this.mLoadMoreAction.onAction();
                this.isLoadingMore = true;
            }
        } else {
            holder.setData(this.mViewsData.get(position));
        }
    }
}

