/*
 * Decompiled with CFR 0.152.
 */
package cn.lemon.view;

import android.content.Context;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import cn.lemon.view.R;
import cn.lemon.view.SpaceItemDecoration;
import cn.lemon.view.adapter.Action;
import cn.lemon.view.adapter.RecyclerAdapter;

public class RefreshRecyclerView
extends FrameLayout {
    private final String TAG = "RefreshRecyclerView";
    private boolean isAllowRefresh = true;
    private SwipeRefreshLayout mSwipeRefreshLayout;
    private RecyclerView mRecyclerView;
    private RecyclerAdapter mAdapter;

    public RefreshRecyclerView(Context context) {
        this(context, null);
    }

    public RefreshRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RefreshRecyclerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View view = RefreshRecyclerView.inflate((Context)context, (int)R.layout.view_refresh_recycler, (ViewGroup)this);
        this.mRecyclerView = (RecyclerView)view.findViewById(R.id.$_recycler_view);
        this.mSwipeRefreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.$_refresh_layout);
    }

    public void setAdapter(RecyclerAdapter adapter) {
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)adapter);
        this.mAdapter = adapter;
    }

    public void setLayoutManager(RecyclerView.LayoutManager layoutManager) {
        this.mRecyclerView.setLayoutManager(layoutManager);
    }

    public void setRefreshAction(final Action action) {
        this.mSwipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                if (!RefreshRecyclerView.this.isAllowRefresh) {
                    return;
                }
                ((RefreshRecyclerView)RefreshRecyclerView.this).mAdapter.isRefreshing = true;
                action.onAction();
            }
        });
    }

    public void setLoadMoreAction(Action action) {
        Log.i((String)"RefreshRecyclerView", (String)"setLoadMoreAction");
        if (this.mAdapter.isShowNoMore) {
            return;
        }
        this.mAdapter.setLoadMoreAction(action);
    }

    public void showNoMore() {
        this.mAdapter.showNoMore();
    }

    public void setRefreshAble(boolean refreshAble) {
        this.isAllowRefresh = refreshAble;
    }

    public void setItemSpace(int left, int top, int right, int bottom) {
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new SpaceItemDecoration(left, top, right, bottom));
    }

    public void addItemDecoration(RecyclerView.ItemDecoration itemDecoration) {
        this.mRecyclerView.addItemDecoration(itemDecoration);
    }

    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    public SwipeRefreshLayout getSwipeRefreshLayout() {
        return this.mSwipeRefreshLayout;
    }

    public void setSwipeRefreshColorsFromRes(int ... colors) {
        this.mSwipeRefreshLayout.setColorSchemeResources(colors);
    }

    public void setSwipeRefreshColors(int ... colors) {
        this.mSwipeRefreshLayout.setColorSchemeColors(colors);
    }

    public void showSwipeRefresh() {
        this.mSwipeRefreshLayout.setRefreshing(true);
    }

    public void dismissSwipeRefresh() {
        this.mSwipeRefreshLayout.setRefreshing(false);
    }
}

