/*
 * Decompiled with CFR 0.152.
 */
package cn.kerison.kit.event.core;

import cn.kerison.kit.event.annotation.Event;
import cn.kerison.kit.event.core.EventHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EventAnnotationFinder {
    private static final Map<Class<?>, Map<Class<?>, Set<EventHandler>>> EVENT_CACHE = new HashMap();

    private EventAnnotationFinder() {
    }

    public static Map<Class<?>, Set<EventHandler>> findAllEvents(Object target) {
        Class<?> targetClass = target.getClass();
        if (!EVENT_CACHE.containsKey(targetClass)) {
            return EventAnnotationFinder.loadTargetMethods(target);
        }
        return EVENT_CACHE.get(targetClass);
    }

    private static Map<Class<?>, Set<EventHandler>> loadTargetMethods(Object target) {
        Class<?> targetClass = target.getClass();
        HashMap targetEventMethods = new HashMap();
        for (Method method : targetClass.getDeclaredMethods()) {
            if (method.isBridge() || !method.isAnnotationPresent(Event.class)) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1) {
                throw new IllegalArgumentException("Method " + method + " with @Event annotation has " + parameterTypes.length + " arguments.  Methods must require a single argument.");
            }
            Class<?> eventType = parameterTypes[0];
            if (eventType.isInterface()) {
                throw new IllegalArgumentException("Method " + method + " with @Event annotation parameter " + eventType + " which is an interface.  EventObject must be on a concrete class type.");
            }
            Event event = method.getAnnotation(Event.class);
            HashSet<EventHandler> methods = (HashSet<EventHandler>)targetEventMethods.get(eventType);
            EventHandler eventMap = new EventHandler(target, method, event.value());
            if (methods == null) {
                methods = new HashSet<EventHandler>();
                targetEventMethods.put(eventType, methods);
            }
            methods.add(eventMap);
        }
        EVENT_CACHE.put(targetClass, targetEventMethods);
        return targetEventMethods;
    }
}

