/*
 * Decompiled with CFR 0.152.
 */
package com.td.library;

import android.util.Log;

public class TDLog {
    private static final String TAG = TDLog.class.getSimpleName();
    private static final int VERBOSE = 2;
    private static final int DEBUG = 3;
    private static final int INFO = 4;
    private static final int WARN = 5;
    private static final int ERROR = 6;
    private static boolean isShowLog = true;

    public static void init(boolean isShowLog) {
        TDLog.isShowLog = isShowLog;
    }

    public static void i(Object obj) {
        TDLog.print(4, null, obj);
    }

    public static void i(String tag, Object obj) {
        TDLog.print(4, tag, obj);
    }

    public static void d(Object obj) {
        TDLog.print(3, null, obj);
    }

    public static void d(String tag, Object obj) {
        TDLog.print(3, tag, obj);
    }

    public static void w(Object obj) {
        TDLog.print(5, null, obj);
    }

    public static void w(String tag, Object obj) {
        TDLog.print(5, tag, obj);
    }

    public static void e(Object obj) {
        TDLog.print(6, null, obj);
    }

    public static void e(String tag, Object obj) {
        TDLog.print(6, tag, obj);
    }

    public static void v(Object obj) {
        TDLog.print(2, null, obj);
    }

    public static void v(String tag, Object obj) {
        TDLog.print(2, tag, obj);
    }

    private static void print(int type, String tag, Object obj) {
        if (!isShowLog) {
            return;
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int index = 4;
        String className = stackTrace[index].getFileName();
        String methodName = stackTrace[index].getMethodName();
        int lineNumber = stackTrace[index].getLineNumber();
        String tagStr = tag == null ? className : tag;
        methodName = methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ ").append(methodName).append(":").append(lineNumber).append(" ] ");
        if (obj == null || obj.toString().length() == 0) {
            stringBuilder.append("Log no Object");
        } else {
            stringBuilder.append(obj.toString());
        }
        String logStr = stringBuilder.toString();
        switch (type) {
            case 2: {
                Log.v((String)tagStr, (String)logStr);
                break;
            }
            case 3: {
                Log.d((String)tagStr, (String)logStr);
                break;
            }
            case 4: {
                Log.i((String)tagStr, (String)logStr);
                break;
            }
            case 5: {
                Log.w((String)tagStr, (String)logStr);
                break;
            }
            case 6: {
                Log.e((String)tagStr, (String)logStr);
            }
        }
    }
}

