/*
 * Decompiled with CFR 0.152.
 */
package cn.junhua.android.permission.special.operation;

import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.view.Window;
import cn.junhua.android.permission.agent.PermissionHandler;
import cn.junhua.android.permission.rom.Rom;
import cn.junhua.android.permission.special.SpecialOperation;
import cn.junhua.android.permission.utils.PermissionUtil;

public class OverlaySpecialOperation
implements SpecialOperation {
    @Override
    public void startActivityForResult(PermissionHandler permissionHandler, int requestCode) {
        Rom.currentRom().createOverlayLauncher().launch(permissionHandler, requestCode);
    }

    @Override
    public boolean checkPermission(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return Settings.canDrawOverlays((Context)context) && this.tryDisplayDialog(context);
        }
        if (Build.VERSION.SDK_INT >= 19) {
            return PermissionUtil.checkOpNoThrow(context, "OP_SYSTEM_ALERT_WINDOW");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryDisplayDialog(Context context) {
        Dialog dialog = new Dialog(context, 0x1030010);
        int windowType = Build.VERSION.SDK_INT >= 26 ? 2038 : 2003;
        Window window = dialog.getWindow();
        if (window != null) {
            window.setType(windowType);
        }
        try {
            dialog.show();
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (dialog.isShowing()) {
                dialog.dismiss();
            }
        }
        return true;
    }
}

