/*
 * Decompiled with CFR 0.152.
 */
package cn.junhua.android.permission.special.operation;

import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import cn.junhua.android.permission.agent.PermissionHandler;
import cn.junhua.android.permission.rom.Rom;
import cn.junhua.android.permission.special.SpecialOperation;
import cn.junhua.android.permission.utils.PermissionUtil;

public class NotificationSpecialOperation
implements SpecialOperation {
    @Override
    public void startActivityForResult(PermissionHandler permissionHandler, int requestCode) {
        Rom.currentRom().createNotifyLauncher().launch(permissionHandler, requestCode);
    }

    @Override
    public boolean checkPermission(Context context) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            return notificationManager.areNotificationsEnabled();
        }
        if (Build.VERSION.SDK_INT >= 19) {
            return PermissionUtil.checkOpNoThrow(context, "OP_POST_NOTIFICATION");
        }
        return true;
    }
}

