/*
 * Decompiled with CFR 0.152.
 */
package cn.junhua.android.permission.special;

import android.content.Intent;
import cn.junhua.android.permission.agent.AgentExecutor;
import cn.junhua.android.permission.agent.PermissionHandler;
import cn.junhua.android.permission.agent.callback.OnActivityResultCallback;
import cn.junhua.android.permission.impl.BaseAgent;
import cn.junhua.android.permission.special.SpecialPermission;
import cn.junhua.android.permission.utils.AgentLog;
import cn.junhua.android.permission.utils.Executor;

public class SpecialPermissionAgent
extends BaseAgent<SpecialPermission>
implements OnActivityResultCallback,
AgentExecutor {
    private static final String TAG = SpecialPermissionAgent.class.getSimpleName();
    private SpecialPermission mSpecialPermission;

    public SpecialPermissionAgent(Executor executor, PermissionHandler permissionHandler, SpecialPermission specialPermission) {
        super(executor, permissionHandler);
        this.mSpecialPermission = specialPermission;
        this.mPermissionHandler.setActivityResultCallback(this);
    }

    private boolean checkPermission() {
        return this.mSpecialPermission.checkPermission(this.mPermissionHandler.getContext());
    }

    @Override
    public void apply() {
        this.mExecutor.post(new Runnable(){

            @Override
            public void run() {
                if (SpecialPermissionAgent.this.checkPermission()) {
                    SpecialPermissionAgent.this.dispatchGranted(SpecialPermissionAgent.this.mSpecialPermission);
                    return;
                }
                SpecialPermissionAgent.this.dispatchRationale(SpecialPermissionAgent.this.mSpecialPermission, SpecialPermissionAgent.this);
            }
        });
    }

    @Override
    public void onActivityResultCallback(int requestCode, int resultCode, Intent data) {
        AgentLog.d(TAG, "onActivityResultCallback() called with: requestCode = [" + requestCode + "], resultCode = [" + resultCode + "], data = [" + data + "]");
        if (this.mRequestCode != requestCode) {
            return;
        }
        this.mExecutor.post(new Runnable(){

            @Override
            public void run() {
                if (SpecialPermissionAgent.this.checkPermission()) {
                    SpecialPermissionAgent.this.dispatchGranted(SpecialPermissionAgent.this.mSpecialPermission);
                } else {
                    SpecialPermissionAgent.this.dispatchDenied(SpecialPermissionAgent.this.mSpecialPermission);
                }
            }
        });
    }

    @Override
    public void execute() {
        this.mExecutor.post(new Runnable(){

            @Override
            public void run() {
                SpecialPermissionAgent.this.mSpecialPermission.startActivityForResult(SpecialPermissionAgent.this.mPermissionHandler, SpecialPermissionAgent.this.mRequestCode);
            }
        });
    }

    @Override
    public void cancel() {
        this.dispatchDenied(this.mSpecialPermission);
    }
}

