/*
 * Decompiled with CFR 0.152.
 */
package cn.junhua.android.permission.rom;

import cn.junhua.android.permission.rom.PageLauncher;
import cn.junhua.android.permission.rom.RomPageLauncherFactory;
import cn.junhua.android.permission.rom.base.PageLauncherProxy;
import cn.junhua.android.permission.rom.default0.Default0PageLauncherFactory;
import cn.junhua.android.permission.rom.huawei.HuaweiPageLauncherFactory;
import cn.junhua.android.permission.rom.meizu.MeizuPageLauncherFactory;
import cn.junhua.android.permission.rom.oppo.OppoPageLauncherFactory;
import cn.junhua.android.permission.rom.qihu360.Qihu360PageLauncherFactory;
import cn.junhua.android.permission.rom.vivo.VivoPageLauncherFactory;
import cn.junhua.android.permission.rom.xiaomi.XiaomiPageLauncherFactory;

public enum Rom implements RomPageLauncherFactory
{
    Huawei(new HuaweiPageLauncherFactory()),
    Xiaomi(new XiaomiPageLauncherFactory()),
    Vivo(new VivoPageLauncherFactory()),
    Oppo(new OppoPageLauncherFactory()),
    Meizu(new MeizuPageLauncherFactory()),
    Qihu360(new Qihu360PageLauncherFactory()),
    Default(new Default0PageLauncherFactory());

    private static Rom CURRENT_ROM;
    private RomPageLauncherFactory mRomPageLauncherFactory;
    private RomPageLauncherFactory mDefault0RomPageLauncherFactory;

    private Rom(RomPageLauncherFactory romFactory) {
        this.mRomPageLauncherFactory = romFactory;
        this.mDefault0RomPageLauncherFactory = new Default0PageLauncherFactory();
    }

    public static Rom currentRom() {
        if (CURRENT_ROM == null) {
            for (Rom rom : Rom.values()) {
                if (!rom.check()) continue;
                CURRENT_ROM = rom;
                break;
            }
        }
        return CURRENT_ROM;
    }

    @Override
    public boolean check() {
        return this.mRomPageLauncherFactory.check();
    }

    @Override
    public PageLauncher createInstallLauncher() {
        return new PageLauncherProxy(this.mRomPageLauncherFactory.createInstallLauncher(), this.mDefault0RomPageLauncherFactory.createInstallLauncher());
    }

    @Override
    public PageLauncher createNotifyLauncher() {
        return new PageLauncherProxy(this.mRomPageLauncherFactory.createNotifyLauncher(), this.mDefault0RomPageLauncherFactory.createNotifyLauncher());
    }

    @Override
    public PageLauncher createOverlayLauncher() {
        return new PageLauncherProxy(this.mRomPageLauncherFactory.createOverlayLauncher(), this.mDefault0RomPageLauncherFactory.createOverlayLauncher());
    }

    @Override
    public PageLauncher createWriteSettingsLauncher() {
        return new PageLauncherProxy(this.mRomPageLauncherFactory.createWriteSettingsLauncher(), this.mDefault0RomPageLauncherFactory.createWriteSettingsLauncher());
    }

    @Override
    public PageLauncher createAppDetailLauncher() {
        return new PageLauncherProxy(this.mRomPageLauncherFactory.createAppDetailLauncher(), this.mDefault0RomPageLauncherFactory.createAppDetailLauncher());
    }
}

