/*
 * Decompiled with CFR 0.152.
 */
package cn.junhua.android.permission.impl;

import android.app.Activity;
import android.app.Fragment;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import cn.junhua.android.permission.agent.PermissionHandler;
import cn.junhua.android.permission.agent.PermissionHandlerFactory;
import cn.junhua.android.permission.impl.ActivityHolder;
import cn.junhua.android.permission.impl.fragment.DefaultPermissionHandler;
import cn.junhua.android.permission.impl.fragment.SupportV4PermissionHandler;

public class PermissionHandlerFactoryImp
implements PermissionHandlerFactory {
    private ActivityHolder mActivityHolder;

    public PermissionHandlerFactoryImp(ActivityHolder activityHolder) {
        this.mActivityHolder = activityHolder;
    }

    @Override
    public PermissionHandler create() {
        Activity activity = this.mActivityHolder.getCurrentActivity();
        if (activity instanceof FragmentActivity) {
            return this.genV4Handler((FragmentActivity)activity);
        }
        return this.genHandler(activity);
    }

    private PermissionHandler genV4Handler(@NonNull FragmentActivity fragmentActivity) {
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        android.support.v4.app.Fragment fragment = fragmentManager.findFragmentByTag("ResultV4Fragment_1206");
        if (!(fragment instanceof SupportV4PermissionHandler)) {
            fragment = new SupportV4PermissionHandler();
            fragmentManager.beginTransaction().add(fragment, "ResultV4Fragment_1206").commitAllowingStateLoss();
        }
        return (PermissionHandler)fragment;
    }

    private PermissionHandler genHandler(@NonNull Activity activity) {
        android.app.FragmentManager fragmentManager = activity.getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("ResultFragment_1206");
        if (!(fragment instanceof DefaultPermissionHandler)) {
            fragment = new DefaultPermissionHandler();
            fragmentManager.beginTransaction().add(fragment, "ResultFragment_1206").commitAllowingStateLoss();
        }
        return (PermissionHandler)fragment;
    }
}

