/*
 * Decompiled with CFR 0.152.
 */
package cn.junhua.android.permission.impl;

import android.content.Context;
import cn.junhua.android.permission.agent.Agent;
import cn.junhua.android.permission.agent.AgentExecutor;
import cn.junhua.android.permission.agent.PermissionHandler;
import cn.junhua.android.permission.agent.callback.OnDeniedCallback;
import cn.junhua.android.permission.agent.callback.OnGrantedCallback;
import cn.junhua.android.permission.agent.callback.OnRationaleCallback;
import cn.junhua.android.permission.utils.Executor;

public abstract class BaseAgent<T>
implements Agent<T> {
    private static final int REQUEST_CODE = 4646;
    protected int mRequestCode = 4646;
    protected Executor mExecutor;
    protected PermissionHandler mPermissionHandler;
    private OnGrantedCallback<T> mOnGrantedCallback;
    private OnDeniedCallback<T> mOnDeniedCallback;
    private OnRationaleCallback<T> mOnRationaleCallback = new OnRationaleCallback<T>(){

        @Override
        public void onRationale(Context context, T permissions, AgentExecutor executor) {
            executor.execute();
        }
    };

    public BaseAgent(Executor executor, PermissionHandler permissionHandler) {
        this.mExecutor = executor;
        this.mPermissionHandler = permissionHandler;
    }

    @Override
    public Agent<T> code(int requestCode) {
        this.mRequestCode = requestCode;
        return this;
    }

    @Override
    public Agent<T> onGranted(OnGrantedCallback<T> onGrantedCallback) {
        this.mOnGrantedCallback = onGrantedCallback;
        return this;
    }

    @Override
    public Agent<T> onDenied(OnDeniedCallback<T> onDeniedCallback) {
        this.mOnDeniedCallback = onDeniedCallback;
        return this;
    }

    @Override
    public Agent<T> onRationale(OnRationaleCallback<T> rationale) {
        this.mOnRationaleCallback = rationale;
        return this;
    }

    protected void dispatchGranted(final T permissions) {
        if (this.mOnGrantedCallback != null) {
            this.mExecutor.post(new Runnable(){

                @Override
                public void run() {
                    BaseAgent.this.mOnGrantedCallback.onGranted(BaseAgent.this.mPermissionHandler.getContext(), permissions);
                }
            });
        }
    }

    protected void dispatchDenied(final T permissions) {
        if (this.mOnDeniedCallback != null) {
            this.mExecutor.post(new Runnable(){

                @Override
                public void run() {
                    BaseAgent.this.mOnDeniedCallback.onDenied(BaseAgent.this.mPermissionHandler.getContext(), permissions);
                }
            });
        }
    }

    protected void dispatchRationale(final T permissions, final AgentExecutor executor) {
        if (this.mOnRationaleCallback != null) {
            this.mExecutor.post(new Runnable(){

                @Override
                public void run() {
                    BaseAgent.this.mOnRationaleCallback.onRationale(BaseAgent.this.mPermissionHandler.getContext(), permissions, executor);
                }
            });
        }
    }
}

