/*
 * Decompiled with CFR 0.152.
 */
package cn.junhua.android.permission.impl;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import cn.junhua.android.permission.utils.AgentLog;
import java.util.ArrayList;
import java.util.List;

public class ActivityHolder
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = ActivityHolder.class.getSimpleName();
    private List<Activity> mActivityList = new ArrayList<Activity>();

    public ActivityHolder(Application application) {
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public Activity getCurrentActivity() {
        if (this.mActivityList.isEmpty()) {
            throw new IllegalStateException("\u8bf7\u5728Application\u7684onCreate\u4e2d\u521d\u59cb\u5316");
        }
        AgentLog.d(TAG, "current activity stack " + this.mActivityList);
        return this.mActivityList.get(this.mActivityList.size() - 1);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        this.mActivityList.add(activity);
        AgentLog.d(TAG, "[" + activity + "] is added to ActivityHolder");
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.mActivityList.remove(activity);
        AgentLog.d(TAG, "[" + activity + "] is removed by ActivityHolder");
    }
}

