/*
 * Decompiled with CFR 0.152.
 */
package cn.junhua.android.permission.dangerous.checker;

import android.content.Context;
import android.content.pm.PackageManager;
import android.media.AudioRecord;
import cn.junhua.android.permission.agent.check.PermissionTester;

class RecordAudioTester
implements PermissionTester {
    private static final int[] RATES = new int[]{8000, 11025, 22050, 44100};
    private Context mContext;

    RecordAudioTester(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test() throws Throwable {
        block7: {
            AudioRecord audioRecord = RecordAudioTester.findAudioRecord();
            try {
                if (audioRecord != null) {
                    audioRecord.startRecording();
                    break block7;
                }
                boolean bl = !RecordAudioTester.existMicrophone(this.mContext);
                return bl;
            }
            catch (Throwable e) {
                boolean bl = !RecordAudioTester.existMicrophone(this.mContext);
                return bl;
            }
            finally {
                if (audioRecord != null) {
                    audioRecord.stop();
                    audioRecord.release();
                }
            }
        }
        return true;
    }

    private static boolean existMicrophone(Context context) {
        PackageManager packageManager = context.getPackageManager();
        return packageManager.hasSystemFeature("android.hardware.microphone");
    }

    private static AudioRecord findAudioRecord() {
        for (int rate : RATES) {
            for (short format : new short[]{3, 2}) {
                for (short channel : new short[]{16, 12}) {
                    AudioRecord recorder;
                    int buffer = AudioRecord.getMinBufferSize((int)rate, (int)channel, (int)format);
                    if (buffer == -2 || (recorder = new AudioRecord(1, rate, (int)channel, (int)format, buffer)).getState() != 1) continue;
                    return recorder;
                }
            }
        }
        return null;
    }
}

