/*
 * Decompiled with CFR 0.152.
 */
package cn.junhua.android.permission.dangerous.checker;

import android.os.Build;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Permission {
    private static final Map<String, List<String>> GROUP_MAP = new HashMap<String, List<String>>();
    private static final String READ_CALENDAR = "android.permission.READ_CALENDAR";
    private static final String WRITE_CALENDAR = "android.permission.WRITE_CALENDAR";
    private static final String CAMERA = "android.permission.CAMERA";
    private static final String READ_CONTACTS = "android.permission.READ_CONTACTS";
    private static final String WRITE_CONTACTS = "android.permission.WRITE_CONTACTS";
    private static final String GET_ACCOUNTS = "android.permission.GET_ACCOUNTS";
    private static final String ACCESS_FINE_LOCATION = "android.permission.ACCESS_FINE_LOCATION";
    private static final String ACCESS_COARSE_LOCATION = "android.permission.ACCESS_COARSE_LOCATION";
    private static final String RECORD_AUDIO = "android.permission.RECORD_AUDIO";
    private static final String READ_PHONE_STATE = "android.permission.READ_PHONE_STATE";
    private static final String CALL_PHONE = "android.permission.CALL_PHONE";
    private static final String READ_CALL_LOG = "android.permission.READ_CALL_LOG";
    private static final String WRITE_CALL_LOG = "android.permission.WRITE_CALL_LOG";
    private static final String ADD_VOICEMAIL = "com.android.voicemail.permission.ADD_VOICEMAIL";
    private static final String USE_SIP = "android.permission.USE_SIP";
    private static final String PROCESS_OUTGOING_CALLS = "android.permission.PROCESS_OUTGOING_CALLS";
    private static final String READ_PHONE_NUMBERS = "android.permission.READ_PHONE_NUMBERS";
    private static final String ANSWER_PHONE_CALLS = "android.permission.ANSWER_PHONE_CALLS";
    private static final String BODY_SENSORS = "android.permission.BODY_SENSORS";
    private static final String SEND_SMS = "android.permission.SEND_SMS";
    private static final String RECEIVE_SMS = "android.permission.RECEIVE_SMS";
    private static final String READ_SMS = "android.permission.READ_SMS";
    private static final String RECEIVE_WAP_PUSH = "android.permission.RECEIVE_WAP_PUSH";
    private static final String RECEIVE_MMS = "android.permission.RECEIVE_MMS";
    private static final String READ_EXTERNAL_STORAGE = "android.permission.READ_EXTERNAL_STORAGE";
    private static final String WRITE_EXTERNAL_STORAGE = "android.permission.WRITE_EXTERNAL_STORAGE";

    public static List<String> handleGroup(String ... permissions) {
        ArrayList<String> permissionList = new ArrayList<String>();
        for (String permission : permissions) {
            if (GROUP_MAP.containsKey(permission)) {
                List<String> permissionTemp = GROUP_MAP.get(permission);
                if (permissionTemp == null || permissionTemp.isEmpty()) continue;
                permissionList.addAll(permissionTemp);
                continue;
            }
            permissionList.add(permission);
        }
        return permissionList;
    }

    static {
        GROUP_MAP.put("android.permission-group.CALENDAR", Arrays.asList(READ_CALENDAR, WRITE_CALENDAR));
        GROUP_MAP.put("android.permission-group.CALL_LOG", Collections.emptyList());
        GROUP_MAP.put("android.permission-group.CAMERA", Collections.singletonList(CAMERA));
        GROUP_MAP.put("android.permission-group.CONTACTS", Arrays.asList(READ_CONTACTS, WRITE_CONTACTS, GET_ACCOUNTS));
        GROUP_MAP.put("android.permission-group.LOCATION", Arrays.asList(ACCESS_FINE_LOCATION, ACCESS_COARSE_LOCATION));
        GROUP_MAP.put("android.permission-group.MICROPHONE", Collections.singletonList(RECORD_AUDIO));
        if (Build.VERSION.SDK_INT >= 26) {
            GROUP_MAP.put("android.permission-group.PHONE", Arrays.asList(READ_PHONE_STATE, CALL_PHONE, READ_CALL_LOG, WRITE_CALL_LOG, ADD_VOICEMAIL, USE_SIP, PROCESS_OUTGOING_CALLS, READ_PHONE_NUMBERS, ANSWER_PHONE_CALLS));
        } else {
            GROUP_MAP.put("android.permission-group.PHONE", Arrays.asList(READ_PHONE_STATE, CALL_PHONE, READ_CALL_LOG, WRITE_CALL_LOG, ADD_VOICEMAIL, USE_SIP, PROCESS_OUTGOING_CALLS));
        }
        GROUP_MAP.put("android.permission-group.SENSORS", Collections.singletonList(BODY_SENSORS));
        GROUP_MAP.put("android.permission-group.SMS", Arrays.asList(SEND_SMS, RECEIVE_SMS, READ_SMS, RECEIVE_WAP_PUSH, RECEIVE_MMS));
        GROUP_MAP.put("android.permission-group.STORAGE", Arrays.asList(READ_EXTERNAL_STORAGE, WRITE_EXTERNAL_STORAGE));
    }

    private static final class Group {
        private static final String CALENDAR = "android.permission-group.CALENDAR";
        private static final String CALL_LOG = "android.permission-group.CALL_LOG";
        private static final String CAMERA = "android.permission-group.CAMERA";
        private static final String CONTACTS = "android.permission-group.CONTACTS";
        private static final String LOCATION = "android.permission-group.LOCATION";
        private static final String MICROPHONE = "android.permission-group.MICROPHONE";
        private static final String PHONE = "android.permission-group.PHONE";
        private static final String SENSORS = "android.permission-group.SENSORS";
        private static final String SMS = "android.permission-group.SMS";
        private static final String STORAGE = "android.permission-group.STORAGE";

        private Group() {
        }
    }
}

