/*
 * Decompiled with CFR 0.152.
 */
package cn.junhua.android.permission.dangerous;

import android.content.Context;
import android.support.annotation.NonNull;
import cn.junhua.android.permission.agent.AgentExecutor;
import cn.junhua.android.permission.agent.PermissionHandler;
import cn.junhua.android.permission.agent.callback.OnPermissionResultCallback;
import cn.junhua.android.permission.agent.check.PermissionChecker;
import cn.junhua.android.permission.dangerous.checker.DoublePermissionChecker;
import cn.junhua.android.permission.dangerous.checker.Permission;
import cn.junhua.android.permission.dangerous.checker.StandardPermissionChecker;
import cn.junhua.android.permission.impl.BaseAgent;
import cn.junhua.android.permission.utils.AgentLog;
import cn.junhua.android.permission.utils.Executor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DangerousPermissionAgent
extends BaseAgent<List<String>>
implements OnPermissionResultCallback {
    private static final String TAG = DangerousPermissionAgent.class.getSimpleName();
    private static final PermissionChecker DOUBLE_CHECKER = new DoublePermissionChecker();
    private static final PermissionChecker STANDARD_CHECKER = new StandardPermissionChecker();
    private List<String> mPermissions;

    public DangerousPermissionAgent(Executor executor, PermissionHandler permissionHandler, String[] permissions) {
        super(executor, permissionHandler);
        this.mPermissions = this.onInitPermissions(permissions);
        this.mPermissionHandler.setOnPermissionResultCallback(this);
    }

    public List<String> onInitPermissions(String[] permissions) {
        return Permission.handleGroup(permissions);
    }

    public List<String> getPermissions() {
        return this.mPermissions;
    }

    @Override
    public void apply() {
        this.mExecutor.post(new Runnable(){

            @Override
            public void run() {
                Context context = DangerousPermissionAgent.this.mPermissionHandler.getContext();
                if (STANDARD_CHECKER.hasPermissions(context, DangerousPermissionAgent.this.getPermissions())) {
                    DangerousPermissionAgent.this.dispatchGranted(DangerousPermissionAgent.this.getPermissions());
                    return;
                }
                ArrayList<String> rationaleList = new ArrayList<String>(1);
                final ArrayList<String> grantedList = new ArrayList<String>(1);
                for (String permission : DangerousPermissionAgent.this.getPermissions()) {
                    if (DangerousPermissionAgent.this.mPermissionHandler.shouldShowRationale(permission)) {
                        rationaleList.add(permission);
                        continue;
                    }
                    if (!STANDARD_CHECKER.hasPermissions(context, permission)) continue;
                    grantedList.add(permission);
                }
                if (rationaleList.isEmpty()) {
                    DangerousPermissionAgent.this.requestPermission(DangerousPermissionAgent.this.getPermissions());
                } else {
                    AgentLog.d(TAG, "dispatchRationale() called with: rationaleList = [" + rationaleList + "]");
                    DangerousPermissionAgent.this.dispatchRationale(rationaleList, new AgentExecutor(){

                        @Override
                        public void execute() {
                            DangerousPermissionAgent.this.requestPermission(DangerousPermissionAgent.this.getPermissions());
                        }

                        @Override
                        public void cancel() {
                            ArrayList<String> tempPermissions = new ArrayList<String>(DangerousPermissionAgent.this.getPermissions());
                            tempPermissions.removeAll(grantedList);
                            if (!tempPermissions.isEmpty()) {
                                DangerousPermissionAgent.this.dispatchDenied(tempPermissions);
                            }
                            if (!grantedList.isEmpty()) {
                                DangerousPermissionAgent.this.dispatchGranted(grantedList);
                            }
                        }
                    });
                }
            }
        }, 100L);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, final @NonNull String[] permissions, @NonNull int[] grantResults) {
        AgentLog.d(TAG, "onRequestPermissionsResult() called with: requestCode = [" + requestCode + "], permissions = " + Arrays.toString(permissions) + ", grantResults = " + Arrays.toString(grantResults));
        if (requestCode != this.mRequestCode || grantResults.length <= 0) {
            return;
        }
        this.mExecutor.asyncPost(new Runnable(){

            @Override
            public void run() {
                Context context = DangerousPermissionAgent.this.mPermissionHandler.getContext();
                ArrayList<String> grantedList = new ArrayList<String>(1);
                ArrayList<String> deniedList = new ArrayList<String>(1);
                for (String permission : permissions) {
                    if (DOUBLE_CHECKER.hasPermissions(context, permission)) {
                        grantedList.add(permission);
                        continue;
                    }
                    deniedList.add(permission);
                }
                AgentLog.d(TAG, "strict check -->onRequestPermissionsResult() called with:  permissions = " + DangerousPermissionAgent.this.mPermissions + ", grantedList = " + grantedList + ", deniedList = " + deniedList);
                if (!deniedList.isEmpty()) {
                    DangerousPermissionAgent.this.dispatchDenied(deniedList);
                }
                if (!grantedList.isEmpty()) {
                    DangerousPermissionAgent.this.dispatchGranted(grantedList);
                }
            }
        });
    }

    private void requestPermission(final List<String> permissions) {
        this.mExecutor.post(new Runnable(){

            @Override
            public void run() {
                DangerousPermissionAgent.this.mPermissionHandler.requestPermissions(permissions.toArray(new String[0]), DangerousPermissionAgent.this.mRequestCode);
            }
        });
    }
}

