/*
 * Decompiled with CFR 0.152.
 */
package cn.junhua.android.permission.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import cn.junhua.android.permission.agent.PermissionHandler;
import java.util.ArrayList;
import java.util.List;

public class ActivitiesFlat {
    private List<OnIntentAction> mIntentActionList = new ArrayList<OnIntentAction>();
    private PermissionHandler mPermissionHandler;
    private int mRequestCode;

    private ActivitiesFlat(PermissionHandler permissionHandler, int requestCode) {
        this.mPermissionHandler = permissionHandler;
        this.mRequestCode = requestCode;
    }

    public static ActivitiesFlat create(PermissionHandler permissionHandler, int requestCode) {
        return new ActivitiesFlat(permissionHandler, requestCode);
    }

    public ActivitiesFlat addAction(OnIntentAction onIntentAction) {
        if (!this.mIntentActionList.contains(onIntentAction)) {
            this.mIntentActionList.add(onIntentAction);
        }
        return this;
    }

    public boolean start() {
        Context context = this.mPermissionHandler.getContext();
        for (OnIntentAction onIntentAction : this.mIntentActionList) {
            try {
                Intent intentTemp = new Intent();
                onIntentAction.onIntentAction(context, intentTemp);
                if (!this.hasActivity(intentTemp)) continue;
                this.mPermissionHandler.startActivityForResult(intentTemp, this.mRequestCode);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean hasActivity(Intent intent) {
        PackageManager packageManager = this.mPermissionHandler.getContext().getPackageManager();
        return packageManager.queryIntentActivities(intent, 65536).size() > 0;
    }

    public static interface OnIntentAction {
        public void onIntentAction(Context var1, Intent var2);
    }
}

