/*
 * Decompiled with CFR 0.152.
 */
package cn.junhua.android.permission.rom;

import cn.junhua.android.permission.rom.PageLauncher;
import cn.junhua.android.permission.rom.RomPageLauncherFactory;
import cn.junhua.android.permission.rom.base.WrapperPagerLauncher;
import cn.junhua.android.permission.rom.default0.Default0PageLauncherFactory;
import cn.junhua.android.permission.rom.huawei.HuaweiPageLauncherFactory;
import cn.junhua.android.permission.rom.meizu.MeizuPageLauncherFactory;
import cn.junhua.android.permission.rom.oppo.OppoPageLauncherFactory;
import cn.junhua.android.permission.rom.qihu360.Qihu360PageLauncherFactory;
import cn.junhua.android.permission.rom.vivo.VivoPageLauncherFactory;
import cn.junhua.android.permission.rom.xiaomi.XiaomiPageLauncherFactory;

public enum Rom implements RomPageLauncherFactory
{
    Huawei(new HuaweiPageLauncherFactory()),
    Xiaomi(new XiaomiPageLauncherFactory()),
    Vivo(new VivoPageLauncherFactory()),
    Oppo(new OppoPageLauncherFactory()),
    Meizu(new MeizuPageLauncherFactory()),
    Qihu360(new Qihu360PageLauncherFactory()),
    Default(new Default0PageLauncherFactory());

    private static Rom CURRENT_ROM;
    private RomPageLauncherFactory mRomPageLauncherFactory;
    private RomPageLauncherFactory mDefaultRomPageLauncherFactory;

    private Rom(RomPageLauncherFactory romFactory) {
        this.mRomPageLauncherFactory = romFactory;
        this.mDefaultRomPageLauncherFactory = new Default0PageLauncherFactory();
    }

    public static Rom currentRom() {
        if (CURRENT_ROM == null) {
            for (Rom rom : Rom.values()) {
                if (!rom.check()) continue;
                CURRENT_ROM = rom;
                break;
            }
        }
        return CURRENT_ROM;
    }

    @Override
    public boolean check() {
        return this.mRomPageLauncherFactory.check();
    }

    @Override
    public PageLauncher createInstallLauncher() {
        return new WrapperPagerLauncher(this.mRomPageLauncherFactory.createInstallLauncher(), this.mDefaultRomPageLauncherFactory.createInstallLauncher());
    }

    @Override
    public PageLauncher createNotifyLauncher() {
        return new WrapperPagerLauncher(this.mRomPageLauncherFactory.createNotifyLauncher(), this.mDefaultRomPageLauncherFactory.createNotifyLauncher());
    }

    @Override
    public PageLauncher createOverlayLauncher() {
        return new WrapperPagerLauncher(this.mRomPageLauncherFactory.createOverlayLauncher(), this.mDefaultRomPageLauncherFactory.createOverlayLauncher());
    }

    @Override
    public PageLauncher createWriteSettingsLauncher() {
        return new WrapperPagerLauncher(this.mRomPageLauncherFactory.createWriteSettingsLauncher(), this.mDefaultRomPageLauncherFactory.createWriteSettingsLauncher());
    }

    @Override
    public PageLauncher createAppDetailLauncher() {
        return new WrapperPagerLauncher(this.mRomPageLauncherFactory.createAppDetailLauncher(), this.mDefaultRomPageLauncherFactory.createAppDetailLauncher());
    }
}

