/*
 * Decompiled with CFR 0.152.
 */
package cn.junhua.android.permission.dangerous.checker;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import cn.junhua.android.permission.agent.check.PermissionChecker;
import cn.junhua.android.permission.dangerous.checker.AddVoicemailTester;
import cn.junhua.android.permission.dangerous.checker.CalendarReadTester;
import cn.junhua.android.permission.dangerous.checker.CalendarWriteTester;
import cn.junhua.android.permission.dangerous.checker.CallLogReadTester;
import cn.junhua.android.permission.dangerous.checker.CallLogWriteTester;
import cn.junhua.android.permission.dangerous.checker.CameraTester;
import cn.junhua.android.permission.dangerous.checker.ContactsReadTester;
import cn.junhua.android.permission.dangerous.checker.ContactsWriteTester;
import cn.junhua.android.permission.dangerous.checker.LocationCoarseTester;
import cn.junhua.android.permission.dangerous.checker.LocationFineTester;
import cn.junhua.android.permission.dangerous.checker.PhoneStateReadTester;
import cn.junhua.android.permission.dangerous.checker.RecordAudioTester;
import cn.junhua.android.permission.dangerous.checker.SensorsTester;
import cn.junhua.android.permission.dangerous.checker.SipTester;
import cn.junhua.android.permission.dangerous.checker.SmsReadTester;
import cn.junhua.android.permission.dangerous.checker.StorageReadTester;
import cn.junhua.android.permission.dangerous.checker.StorageWriteTester;
import java.util.Arrays;
import java.util.List;

public final class StrictPermissionChecker
implements PermissionChecker {
    private static boolean checkReadCalendar(Context context) throws Throwable {
        CalendarReadTester test = new CalendarReadTester(context);
        return test.test();
    }

    private static boolean checkWriteCalendar(Context context) throws Throwable {
        CalendarWriteTester test = new CalendarWriteTester(context);
        return test.test();
    }

    private static boolean checkCamera(Context context) throws Throwable {
        CameraTester test = new CameraTester(context);
        return test.test();
    }

    private static boolean checkReadContacts(Context context) throws Throwable {
        ContactsReadTester test = new ContactsReadTester(context);
        return test.test();
    }

    private static boolean checkWriteContacts(Context context) throws Throwable {
        ContentResolver resolver = context.getContentResolver();
        ContactsWriteTester test = new ContactsWriteTester(resolver);
        return test.test();
    }

    private static boolean checkCoarseLocation(Context context) throws Throwable {
        LocationCoarseTester test = new LocationCoarseTester(context);
        return test.test();
    }

    private static boolean checkFineLocation(Context context) throws Throwable {
        LocationFineTester test = new LocationFineTester(context);
        return test.test();
    }

    private static boolean checkRecordAudio(Context context) throws Throwable {
        RecordAudioTester test = new RecordAudioTester(context);
        return test.test();
    }

    private static boolean checkReadPhoneState(Context context) throws Throwable {
        PhoneStateReadTester test = new PhoneStateReadTester(context);
        return test.test();
    }

    private static boolean checkReadCallLog(Context context) throws Throwable {
        CallLogReadTester test = new CallLogReadTester(context);
        return test.test();
    }

    private static boolean checkWriteCallLog(Context context) throws Throwable {
        CallLogWriteTester test = new CallLogWriteTester(context);
        return test.test();
    }

    private static boolean checkAddVoicemail(Context context) throws Throwable {
        AddVoicemailTester test = new AddVoicemailTester(context);
        return test.test();
    }

    private static boolean checkSip(Context context) throws Throwable {
        SipTester test = new SipTester(context);
        return test.test();
    }

    private static boolean checkSensors(Context context) throws Throwable {
        SensorsTester test = new SensorsTester(context);
        return test.test();
    }

    private static boolean checkReadSms(Context context) throws Throwable {
        SmsReadTester test = new SmsReadTester(context);
        return test.test();
    }

    private static boolean checkReadStorage() throws Throwable {
        StorageReadTester test = new StorageReadTester();
        return test.test();
    }

    private static boolean checkWriteStorage() throws Throwable {
        StorageWriteTester test = new StorageWriteTester();
        return test.test();
    }

    @Override
    public boolean hasPermissions(Context context, String ... permissions) {
        return this.hasPermissions(context, Arrays.asList(permissions));
    }

    @Override
    public boolean hasPermissions(Context context, List<String> permissions) {
        if (Build.VERSION.SDK_INT < 21) {
            return true;
        }
        for (String permission : permissions) {
            if (this.hasPermissions(context, permission)) continue;
            return false;
        }
        return true;
    }

    private boolean hasPermissions(Context context, String permission) {
        try {
            switch (permission) {
                case "android.permission.READ_CALENDAR": {
                    return StrictPermissionChecker.checkReadCalendar(context);
                }
                case "android.permission.WRITE_CALENDAR": {
                    return StrictPermissionChecker.checkWriteCalendar(context);
                }
                case "android.permission.CAMERA": {
                    return StrictPermissionChecker.checkCamera(context);
                }
                case "android.permission.READ_CONTACTS": {
                    return StrictPermissionChecker.checkReadContacts(context);
                }
                case "android.permission.WRITE_CONTACTS": {
                    return StrictPermissionChecker.checkWriteContacts(context);
                }
                case "android.permission.GET_ACCOUNTS": {
                    return true;
                }
                case "android.permission.ACCESS_COARSE_LOCATION": {
                    return StrictPermissionChecker.checkCoarseLocation(context);
                }
                case "android.permission.ACCESS_FINE_LOCATION": {
                    return StrictPermissionChecker.checkFineLocation(context);
                }
                case "android.permission.RECORD_AUDIO": {
                    return StrictPermissionChecker.checkRecordAudio(context);
                }
                case "android.permission.READ_PHONE_STATE": {
                    return StrictPermissionChecker.checkReadPhoneState(context);
                }
                case "android.permission.CALL_PHONE": {
                    return true;
                }
                case "android.permission.READ_CALL_LOG": {
                    return StrictPermissionChecker.checkReadCallLog(context);
                }
                case "android.permission.WRITE_CALL_LOG": {
                    return StrictPermissionChecker.checkWriteCallLog(context);
                }
                case "com.android.voicemail.permission.ADD_VOICEMAIL": {
                    return StrictPermissionChecker.checkAddVoicemail(context);
                }
                case "android.permission.USE_SIP": {
                    return StrictPermissionChecker.checkSip(context);
                }
                case "android.permission.PROCESS_OUTGOING_CALLS": {
                    return true;
                }
                case "android.permission.BODY_SENSORS": {
                    return StrictPermissionChecker.checkSensors(context);
                }
                case "android.permission.SEND_SMS": 
                case "android.permission.RECEIVE_MMS": {
                    return true;
                }
                case "android.permission.READ_SMS": {
                    return StrictPermissionChecker.checkReadSms(context);
                }
                case "android.permission.RECEIVE_WAP_PUSH": 
                case "android.permission.RECEIVE_SMS": {
                    return true;
                }
                case "android.permission.READ_EXTERNAL_STORAGE": {
                    return StrictPermissionChecker.checkReadStorage();
                }
                case "android.permission.WRITE_EXTERNAL_STORAGE": {
                    return StrictPermissionChecker.checkWriteStorage();
                }
            }
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }
}

