/*
 * Decompiled with CFR 0.152.
 */
package cn.junhua.android.permission;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import cn.junhua.android.permission.agent.Agent;
import cn.junhua.android.permission.agent.PermissionHandler;
import cn.junhua.android.permission.agent.PermissionHandlerFactory;
import cn.junhua.android.permission.agent.check.PermissionChecker;
import cn.junhua.android.permission.dangerous.DangerousPermissionAgent;
import cn.junhua.android.permission.dangerous.EachDangerousPermissionAgent;
import cn.junhua.android.permission.dangerous.checker.DoublePermissionChecker;
import cn.junhua.android.permission.dangerous.checker.Permission;
import cn.junhua.android.permission.impl.ActivityHolder;
import cn.junhua.android.permission.impl.PermissionHandlerFactoryImp;
import cn.junhua.android.permission.rom.Rom;
import cn.junhua.android.permission.special.SpecialPermission;
import cn.junhua.android.permission.special.SpecialPermissionAgent;
import cn.junhua.android.permission.utils.AgentLog;
import cn.junhua.android.permission.utils.Executor;
import java.util.List;

public class PermissionAgent {
    private PermissionHandlerFactory mPermissionHandlerFactory;
    private ActivityHolder mActivityHolder;
    private Executor mExecutor = new Executor();
    private PermissionChecker mDoubleChecker = new DoublePermissionChecker();

    private PermissionAgent() {
    }

    public static PermissionAgent getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public static void setDebug(boolean debug) {
        AgentLog.setDebug(debug);
    }

    public void init(Application application) {
        if (this.mActivityHolder == null) {
            this.mActivityHolder = new ActivityHolder(application);
            this.mPermissionHandlerFactory = new PermissionHandlerFactoryImp(this.mActivityHolder);
        }
    }

    public Agent<List<String>> request(String ... permissions) {
        return new DangerousPermissionAgent(this.mExecutor, this.getPermissionHandler(), permissions);
    }

    public Agent<List<String>> request(List<String> permissions) {
        return this.request(permissions.toArray(new String[0]));
    }

    public Agent<List<String>> requestEach(String ... permissions) {
        return new EachDangerousPermissionAgent(this.mExecutor, this.getPermissionHandler(), permissions);
    }

    public Agent<List<String>> requestEach(List<String> permissions) {
        return this.requestEach(permissions.toArray(new String[0]));
    }

    public Agent<SpecialPermission> request(SpecialPermission permission) {
        return new SpecialPermissionAgent(this.mExecutor, this.getPermissionHandler(), permission);
    }

    public boolean checkPermission(String ... permissions) {
        return this.mDoubleChecker.hasPermissions((Context)this.getCurrentActivity(), Permission.handleGroup(permissions));
    }

    public boolean checkPermission(List<String> permissions) {
        return this.checkPermission(permissions.toArray(new String[0]));
    }

    public boolean checkPermission(SpecialPermission specialPermission) {
        return specialPermission.checkPermission((Context)this.getCurrentActivity());
    }

    public boolean hasAlwaysDeniedPermission(String ... deniedPermissions) {
        PermissionHandler permissionHandler = this.getPermissionHandler();
        for (String permission : deniedPermissions) {
            if (permissionHandler.shouldShowRationale(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAlwaysDeniedPermission(List<String> deniedPermissions) {
        return this.hasAlwaysDeniedPermission(deniedPermissions.toArray(new String[0]));
    }

    public void startSettingPage(int requestCode) {
        Rom.currentRom().createAppDetailLauncher().launch(this.getPermissionHandler(), requestCode);
    }

    public Activity getCurrentActivity() {
        return this.mActivityHolder.getCurrentActivity();
    }

    private PermissionHandler getPermissionHandler() {
        return this.mPermissionHandlerFactory.create();
    }

    private static class InstanceHolder {
        private static final PermissionAgent INSTANCE = new PermissionAgent();

        private InstanceHolder() {
        }
    }
}

