/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model.notification;

import cn.jpush.api.push.model.notification.PlatformNotification;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;

public class QuickappNotification
extends PlatformNotification {
    private static final String NOTIFICATION_QUICKAPP = "quickapp";
    private static final String TITLE = "title";
    private static final String PAGE = "page";
    private final String title;
    private final String page;

    private QuickappNotification(Object alert, String title, String page, Map<String, String> extras, Map<String, Number> numberExtras, Map<String, Boolean> booleanExtras, Map<String, JsonObject> jsonExtras, Map<String, JsonPrimitive> customData) {
        super(alert, extras, numberExtras, booleanExtras, jsonExtras, customData);
        this.title = title;
        this.page = page;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static QuickappNotification alert(String alert) {
        return QuickappNotification.newBuilder().setAlert(alert).build();
    }

    @Override
    public String getPlatform() {
        return NOTIFICATION_QUICKAPP;
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = super.toJSON().getAsJsonObject();
        if (null != this.title) {
            json.add(TITLE, (JsonElement)new JsonPrimitive(this.title));
        }
        if (null != this.page) {
            json.add(PAGE, (JsonElement)new JsonPrimitive(this.page));
        }
        return json;
    }

    public static class Builder
    extends PlatformNotification.Builder<QuickappNotification, Builder> {
        private String title;
        private String page;

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setPage(String page) {
            this.page = page;
            return this;
        }

        @Override
        public Builder setAlert(Object alert) {
            this.alert = alert;
            return this;
        }

        @Override
        public QuickappNotification build() {
            return new QuickappNotification(this.alert, this.title, this.page, this.extrasBuilder, this.numberExtrasBuilder, this.booleanExtrasBuilder, this.jsonExtrasBuilder, this.customData);
        }
    }
}

