/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model;

import cn.jiguang.common.utils.Preconditions;
import cn.jpush.api.push.model.PushModel;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class Message
implements PushModel {
    private static final String MSG_CONTENT = "msg_content";
    private static final String TITLE = "title";
    private static final String CONTENT_TYPE = "content_type";
    private static final String EXTRAS = "extras";
    private final String msgContent;
    private final String title;
    private final String contentType;
    private final Map<String, String> extras;
    private final Map<String, Number> numberExtras;
    private final Map<String, Boolean> booleanExtras;
    private final Map<String, JsonObject> jsonExtras;
    private final Map<String, JsonPrimitive> customData;

    private Message(String title, String msgContent, String contentType, Map<String, String> extras, Map<String, Number> numberExtras, Map<String, Boolean> booleanExtras, Map<String, JsonObject> jsonExtras, Map<String, JsonPrimitive> customData) {
        this.title = title;
        this.msgContent = msgContent;
        this.contentType = contentType;
        this.extras = extras;
        this.numberExtras = numberExtras;
        this.booleanExtras = booleanExtras;
        this.jsonExtras = jsonExtras;
        this.customData = customData;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Message content(String msgContent) {
        return new Builder().setMsgContent(msgContent).build();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (null != this.title) {
            json.add(TITLE, (JsonElement)new JsonPrimitive(this.title));
        }
        if (null != this.msgContent) {
            json.add(MSG_CONTENT, (JsonElement)new JsonPrimitive(this.msgContent));
        }
        if (null != this.contentType) {
            json.add(CONTENT_TYPE, (JsonElement)new JsonPrimitive(this.contentType));
        }
        JsonObject extrasObject = null;
        if (null != this.extras || null != this.numberExtras || null != this.booleanExtras || null != this.jsonExtras) {
            extrasObject = new JsonObject();
        }
        if (null != this.extras) {
            for (String string : this.extras.keySet()) {
                if (this.extras.get(string) != null) {
                    extrasObject.add(string, (JsonElement)new JsonPrimitive(this.extras.get(string)));
                    continue;
                }
                extrasObject.add(string, (JsonElement)JsonNull.INSTANCE);
            }
        }
        if (null != this.numberExtras) {
            for (String string : this.numberExtras.keySet()) {
                extrasObject.add(string, (JsonElement)new JsonPrimitive(this.numberExtras.get(string)));
            }
        }
        if (null != this.booleanExtras) {
            for (String string : this.booleanExtras.keySet()) {
                extrasObject.add(string, (JsonElement)new JsonPrimitive(this.booleanExtras.get(string)));
            }
        }
        if (null != this.jsonExtras) {
            for (String string : this.jsonExtras.keySet()) {
                extrasObject.add(string, (JsonElement)this.jsonExtras.get(string));
            }
        }
        if (null != this.extras || null != this.numberExtras || null != this.booleanExtras || null != this.jsonExtras) {
            json.add(EXTRAS, (JsonElement)extrasObject);
        }
        if (null != this.customData) {
            for (Map.Entry entry : this.customData.entrySet()) {
                json.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        return json;
    }

    public static class Builder {
        private String title;
        private String msgContent;
        private String contentType;
        private Map<String, String> extrasBuilder;
        private Map<String, Number> numberExtrasBuilder;
        private Map<String, Boolean> booleanExtrasBuilder;
        protected Map<String, JsonObject> jsonExtrasBuilder;
        private Map<String, JsonPrimitive> customData;

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setMsgContent(String msgContent) {
            this.msgContent = msgContent;
            return this;
        }

        public Builder setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder addExtra(String key, String value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.extrasBuilder) {
                this.extrasBuilder = new HashMap<String, String>();
            }
            this.extrasBuilder.put(key, value);
            return this;
        }

        public Builder addExtras(Map<String, String> extras) {
            Preconditions.checkArgument((null != extras ? 1 : 0) != 0, (Object)"extras should not be null.");
            if (null == this.extrasBuilder) {
                this.extrasBuilder = new HashMap<String, String>();
            }
            for (String key : extras.keySet()) {
                this.extrasBuilder.put(key, extras.get(key));
            }
            return this;
        }

        public Builder addExtra(String key, Number value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.numberExtrasBuilder) {
                this.numberExtrasBuilder = new HashMap<String, Number>();
            }
            this.numberExtrasBuilder.put(key, value);
            return this;
        }

        public Builder addExtra(String key, Boolean value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.booleanExtrasBuilder) {
                this.booleanExtrasBuilder = new HashMap<String, Boolean>();
            }
            this.booleanExtrasBuilder.put(key, value);
            return this;
        }

        public Builder addExtra(String key, JsonObject value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.jsonExtrasBuilder) {
                this.jsonExtrasBuilder = new HashMap<String, JsonObject>();
            }
            this.jsonExtrasBuilder.put(key, value);
            return this;
        }

        public Builder addCustom(Map<String, String> extras) {
            if (this.customData == null) {
                this.customData = new LinkedHashMap<String, JsonPrimitive>();
            }
            for (Map.Entry<String, String> entry : extras.entrySet()) {
                this.customData.put(entry.getKey(), new JsonPrimitive(entry.getValue()));
            }
            return this;
        }

        public Builder addCustom(String key, Number value) {
            Preconditions.checkArgument((null != key ? 1 : 0) != 0, (Object)"Key should not be null.");
            if (this.customData == null) {
                this.customData = new LinkedHashMap<String, JsonPrimitive>();
            }
            this.customData.put(key, new JsonPrimitive(value));
            return this;
        }

        public Builder addCustom(String key, String value) {
            Preconditions.checkArgument((null != key ? 1 : 0) != 0, (Object)"Key should not be null.");
            if (this.customData == null) {
                this.customData = new LinkedHashMap<String, JsonPrimitive>();
            }
            this.customData.put(key, new JsonPrimitive(value));
            return this;
        }

        public Builder addCustom(String key, Boolean value) {
            Preconditions.checkArgument((null != key ? 1 : 0) != 0, (Object)"Key should not be null.");
            if (this.customData == null) {
                this.customData = new LinkedHashMap<String, JsonPrimitive>();
            }
            this.customData.put(key, new JsonPrimitive(value));
            return this;
        }

        public Message build() {
            Preconditions.checkArgument((null != this.msgContent ? 1 : 0) != 0, (Object)"msgContent should be set");
            return new Message(this.title, this.msgContent, this.contentType, this.extrasBuilder, this.numberExtrasBuilder, this.booleanExtrasBuilder, this.jsonExtrasBuilder, this.customData);
        }
    }
}

