/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.device;

import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.ServiceHelper;
import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.connection.NativeHttpClient;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.BaseResult;
import cn.jiguang.common.resp.BooleanResult;
import cn.jiguang.common.resp.DefaultResult;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.Preconditions;
import cn.jiguang.common.utils.StringUtils;
import cn.jpush.api.device.AliasDeviceListResult;
import cn.jpush.api.device.OnlineStatus;
import cn.jpush.api.device.TagAliasResult;
import cn.jpush.api.device.TagListResult;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;

public class DeviceClient {
    private final NativeHttpClient _httpClient;
    private String hostName;
    private String devicesPath;
    private String tagsPath;
    private String aliasesPath;

    public DeviceClient(String masterSecret, String appKey) {
        this(masterSecret, appKey, null, ClientConfig.getInstance());
    }

    @Deprecated
    public DeviceClient(String masterSecret, String appKey, int maxRetryTimes) {
        this(masterSecret, appKey, maxRetryTimes, null);
    }

    @Deprecated
    public DeviceClient(String masterSecret, String appKey, int maxRetryTimes, HttpProxy proxy) {
        ClientConfig conf = ClientConfig.getInstance();
        conf.setMaxRetryTimes(maxRetryTimes);
        ServiceHelper.checkBasic((String)appKey, (String)masterSecret);
        this.hostName = (String)conf.get((Object)"device.host.name");
        this.devicesPath = (String)conf.get((Object)"devices.path");
        this.tagsPath = (String)conf.get((Object)"tags.path");
        this.aliasesPath = (String)conf.get((Object)"aliases.path");
        String authCode = ServiceHelper.getBasicAuthorization((String)appKey, (String)masterSecret);
        this._httpClient = new NativeHttpClient(authCode, proxy, conf);
    }

    public DeviceClient(String masterSecret, String appKey, HttpProxy proxy, ClientConfig conf) {
        ServiceHelper.checkBasic((String)appKey, (String)masterSecret);
        this.hostName = (String)conf.get((Object)"device.host.name");
        this.devicesPath = (String)conf.get((Object)"devices.path");
        this.tagsPath = (String)conf.get((Object)"tags.path");
        this.aliasesPath = (String)conf.get((Object)"aliases.path");
        String authCode = ServiceHelper.getBasicAuthorization((String)appKey, (String)masterSecret);
        this._httpClient = new NativeHttpClient(authCode, proxy, conf);
    }

    public TagAliasResult getDeviceTagAlias(String registrationId) throws APIConnectionException, APIRequestException {
        String url = this.hostName + this.devicesPath + "/" + registrationId;
        ResponseWrapper response = this._httpClient.sendGet(url);
        return (TagAliasResult)BaseResult.fromResponse((ResponseWrapper)response, TagAliasResult.class);
    }

    public DefaultResult updateDeviceTagAlias(String registrationId, boolean clearAlias, boolean clearTag) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((clearAlias || clearTag ? 1 : 0) != 0, (Object)"It is not meaningful to do nothing.");
        String url = this.hostName + this.devicesPath + "/" + registrationId;
        JsonObject top = new JsonObject();
        if (clearAlias) {
            top.addProperty("alias", "");
        }
        if (clearTag) {
            top.addProperty("tags", "");
        }
        ResponseWrapper response = this._httpClient.sendPost(url, top.toString());
        return DefaultResult.fromResponse((ResponseWrapper)response);
    }

    public DefaultResult updateDeviceTagAlias(String registrationId, String alias, Set<String> tagsToAdd, Set<String> tagsToRemove) throws APIConnectionException, APIRequestException {
        JsonArray tagsRemove;
        String url = this.hostName + this.devicesPath + "/" + registrationId;
        JsonObject top = new JsonObject();
        if (null != alias) {
            top.addProperty("alias", alias);
        }
        JsonObject tagObject = new JsonObject();
        JsonArray tagsAdd = ServiceHelper.fromSet(tagsToAdd);
        if (tagsAdd.size() > 0) {
            tagObject.add("add", (JsonElement)tagsAdd);
        }
        if ((tagsRemove = ServiceHelper.fromSet(tagsToRemove)).size() > 0) {
            tagObject.add("remove", (JsonElement)tagsRemove);
        }
        if (tagObject.entrySet().size() > 0) {
            top.add("tags", (JsonElement)tagObject);
        }
        ResponseWrapper response = this._httpClient.sendPost(url, top.toString());
        return DefaultResult.fromResponse((ResponseWrapper)response);
    }

    public DefaultResult bindMobile(String registrationId, String mobile) throws APIConnectionException, APIRequestException {
        if (StringUtils.isEmpty((String)mobile)) {
            mobile = "";
        }
        String url = this.hostName + this.devicesPath + "/" + registrationId;
        JsonObject top = new JsonObject();
        top.addProperty("mobile", mobile);
        ResponseWrapper response = this._httpClient.sendPost(url, top.toString());
        return DefaultResult.fromResponse((ResponseWrapper)response);
    }

    public TagListResult getTagList() throws APIConnectionException, APIRequestException {
        String url = this.hostName + this.tagsPath + "/";
        ResponseWrapper response = this._httpClient.sendGet(url);
        return (TagListResult)TagListResult.fromResponse((ResponseWrapper)response, TagListResult.class);
    }

    public BooleanResult isDeviceInTag(String theTag, String registrationID) throws APIConnectionException, APIRequestException {
        String url = this.hostName + this.tagsPath + "/" + theTag + "/registration_ids/" + registrationID;
        ResponseWrapper response = this._httpClient.sendGet(url);
        return (BooleanResult)BaseResult.fromResponse((ResponseWrapper)response, BooleanResult.class);
    }

    public DefaultResult addRemoveDevicesFromTag(String theTag, Set<String> toAddUsers, Set<String> toRemoveUsers) throws APIConnectionException, APIRequestException {
        JsonArray array;
        String url = this.hostName + this.tagsPath + "/" + theTag;
        JsonObject top = new JsonObject();
        JsonObject registrationIds = new JsonObject();
        if (null != toAddUsers && toAddUsers.size() > 0) {
            array = new JsonArray();
            for (String user : toAddUsers) {
                array.add((JsonElement)new JsonPrimitive(user));
            }
            registrationIds.add("add", (JsonElement)array);
        }
        if (null != toRemoveUsers && toRemoveUsers.size() > 0) {
            array = new JsonArray();
            for (String user : toRemoveUsers) {
                array.add((JsonElement)new JsonPrimitive(user));
            }
            registrationIds.add("remove", (JsonElement)array);
        }
        top.add("registration_ids", (JsonElement)registrationIds);
        ResponseWrapper response = this._httpClient.sendPost(url, top.toString());
        return DefaultResult.fromResponse((ResponseWrapper)response);
    }

    public DefaultResult deleteTag(String theTag, String platform) throws APIConnectionException, APIRequestException {
        String url = this.hostName + this.tagsPath + "/" + theTag;
        if (null != platform) {
            url = url + "?platform=" + platform;
        }
        ResponseWrapper response = this._httpClient.sendDelete(url);
        return DefaultResult.fromResponse((ResponseWrapper)response);
    }

    public AliasDeviceListResult getAliasDeviceList(String alias, String platform) throws APIConnectionException, APIRequestException {
        String url = this.hostName + this.aliasesPath + "/" + alias;
        if (null != platform) {
            url = url + "?platform=" + platform;
        }
        ResponseWrapper response = this._httpClient.sendGet(url);
        return (AliasDeviceListResult)BaseResult.fromResponse((ResponseWrapper)response, AliasDeviceListResult.class);
    }

    public DefaultResult deleteAlias(String alias, String platform) throws APIConnectionException, APIRequestException {
        String url = this.hostName + this.aliasesPath + "/" + alias;
        if (null != platform) {
            url = url + "?platform=" + platform;
        }
        ResponseWrapper response = this._httpClient.sendDelete(url);
        return DefaultResult.fromResponse((ResponseWrapper)response);
    }

    public DefaultResult removeDevicesFromAlias(String alias, Set<String> toRemoveDevice) throws APIConnectionException, APIRequestException {
        String url = this.hostName + this.aliasesPath + "/" + alias;
        JsonObject top = new JsonObject();
        JsonObject registrationIds = new JsonObject();
        if (null != toRemoveDevice && toRemoveDevice.size() > 0) {
            JsonArray array = new JsonArray();
            for (String device : toRemoveDevice) {
                array.add((JsonElement)new JsonPrimitive(device));
            }
            registrationIds.add("remove", (JsonElement)array);
        }
        top.add("registration_ids", (JsonElement)registrationIds);
        ResponseWrapper response = this._httpClient.sendPost(url, top.toString());
        return DefaultResult.fromResponse((ResponseWrapper)response);
    }

    public Map<String, OnlineStatus> getUserOnlineStatus(String ... registrationIds) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != registrationIds ? 1 : 0) != 0, (Object)"The registration id list should not be null.");
        Preconditions.checkArgument((registrationIds.length > 0 && registrationIds.length <= 1000 ? 1 : 0) != 0, (Object)"The length of registration id list should between 1 and 1000.");
        String url = this.hostName + this.devicesPath + "/status";
        JsonObject json = new JsonObject();
        JsonArray array = new JsonArray();
        for (int i = 0; i < registrationIds.length; ++i) {
            array.add((JsonElement)new JsonPrimitive(registrationIds[i]));
        }
        json.add("registration_ids", (JsonElement)array);
        Type type = new TypeToken<Map<String, OnlineStatus>>(){}.getType();
        ResponseWrapper response = this._httpClient.sendPost(url, json.toString());
        Map map = (Map)new Gson().fromJson(response.responseContent, type);
        return map;
    }
}

