/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push;

import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.ServiceHelper;
import cn.jiguang.common.connection.ApacheHttpClient;
import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.connection.IHttpClient;
import cn.jiguang.common.connection.NativeHttpClient;
import cn.jiguang.common.connection.NettyHttpClient;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.BaseResult;
import cn.jiguang.common.resp.DefaultResult;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.Base64;
import cn.jiguang.common.utils.Preconditions;
import cn.jiguang.common.utils.StringUtils;
import cn.jiguang.common.utils.sm2.SM2Util;
import cn.jpush.api.push.CIDResult;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.BatchPushResult;
import cn.jpush.api.push.model.EncryptKeys;
import cn.jpush.api.push.model.EncryptPushPayload;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.List;

public class PushClient {
    private IHttpClient _httpClient;
    private String _baseUrl;
    private String _pushPath;
    private String _pushValidatePath;
    private String batchRegidPushPath;
    private String batchAliasPushPath;
    private String _filePushPath;
    private JsonParser _jsonParser = new JsonParser();
    private int _apnsProduction;
    private long _timeToLive;
    private String _encryptType;

    public PushClient() {
    }

    public PushClient(String masterSecret, String appKey) {
        this(masterSecret, appKey, null, ClientConfig.getInstance());
    }

    public PushClient(String masterSecret, String appKey, ClientConfig clientConfig) {
        this(masterSecret, appKey, null, clientConfig);
    }

    @Deprecated
    public PushClient(String masterSecret, String appKey, int maxRetryTimes) {
        this(masterSecret, appKey, maxRetryTimes, null);
    }

    @Deprecated
    public PushClient(String masterSecret, String appKey, int maxRetryTimes, HttpProxy proxy) {
        ServiceHelper.checkBasic((String)appKey, (String)masterSecret);
        ClientConfig conf = ClientConfig.getInstance();
        conf.setMaxRetryTimes(maxRetryTimes);
        this._baseUrl = (String)conf.get((Object)"push.host.name");
        this._pushPath = (String)conf.get((Object)"push.path");
        this._pushValidatePath = (String)conf.get((Object)"push.validate.path");
        this._filePushPath = (String)conf.get((Object)"file.push.path");
        this._apnsProduction = (Integer)conf.get((Object)"apns.production");
        this._timeToLive = (Long)conf.get((Object)"time.to.live");
        String authCode = ServiceHelper.getBasicAuthorization((String)appKey, (String)masterSecret);
        this._httpClient = new NativeHttpClient(authCode, proxy, conf);
    }

    public PushClient(String masterSecret, String appKey, HttpProxy proxy, ClientConfig conf) {
        ServiceHelper.checkBasic((String)appKey, (String)masterSecret);
        this._baseUrl = (String)conf.get((Object)"push.host.name");
        this._pushPath = (String)conf.get((Object)"push.path");
        this._pushValidatePath = (String)conf.get((Object)"push.validate.path");
        this._filePushPath = (String)conf.get((Object)"file.push.path");
        this.batchAliasPushPath = (String)conf.get((Object)"batch.alias.path");
        this.batchRegidPushPath = (String)conf.get((Object)"batch.regid.path");
        this._apnsProduction = (Integer)conf.get((Object)"apns.production");
        this._timeToLive = (Long)conf.get((Object)"time.to.live");
        this._encryptType = (String)conf.get((Object)"encrypt.type");
        String authCode = ServiceHelper.getBasicAuthorization((String)appKey, (String)masterSecret);
        this._httpClient = new NativeHttpClient(authCode, proxy, conf);
    }

    @Deprecated
    public PushClient(String masterSecret, String appKey, boolean apnsProduction, long timeToLive) {
        this(masterSecret, appKey);
        this._apnsProduction = apnsProduction ? 1 : 0;
        this._timeToLive = timeToLive;
    }

    @Deprecated
    public void setDefaults(boolean apnsProduction, long timeToLive) {
        this._apnsProduction = apnsProduction ? 1 : 0;
        this._timeToLive = timeToLive;
    }

    public void setBaseUrl(String baseUrl) {
        this._baseUrl = baseUrl;
    }

    public PushResult sendPush(PushPayload pushPayload) throws APIConnectionException, APIRequestException {
        this.checkPushPayload(pushPayload);
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._pushPath, this.getEncryptData(pushPayload));
        return (PushResult)BaseResult.fromResponse((ResponseWrapper)response, PushResult.class);
    }

    public PushResult sendPushValidate(PushPayload pushPayload) throws APIConnectionException, APIRequestException {
        this.checkPushPayload(pushPayload);
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._pushValidatePath, this.getEncryptData(pushPayload));
        return (PushResult)BaseResult.fromResponse((ResponseWrapper)response, PushResult.class);
    }

    public PushResult sendPush(String payloadString) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)payloadString), (Object)"pushPayload should not be empty");
        try {
            this._jsonParser.parse(payloadString);
        }
        catch (JsonParseException e) {
            Preconditions.checkArgument((boolean)false, (Object)"payloadString should be a valid JSON string.");
        }
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._pushPath, this.getEncryptData(payloadString));
        return (PushResult)BaseResult.fromResponse((ResponseWrapper)response, PushResult.class);
    }

    public PushResult sendFilePush(PushPayload pushPayload) throws APIConnectionException, APIRequestException {
        this.checkPushPayload(pushPayload);
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._filePushPath, this.getEncryptData(pushPayload));
        return (PushResult)BaseResult.fromResponse((ResponseWrapper)response, PushResult.class);
    }

    public PushResult sendPushValidate(String payloadString) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)payloadString), (Object)"pushPayload should not be empty");
        try {
            this._jsonParser.parse(payloadString);
        }
        catch (JsonParseException e) {
            Preconditions.checkArgument((boolean)false, (Object)"payloadString should be a valid JSON string.");
        }
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._pushValidatePath, this.getEncryptData(payloadString));
        return (PushResult)BaseResult.fromResponse((ResponseWrapper)response, PushResult.class);
    }

    public BatchPushResult batchSendPushByRegId(List<PushPayload> pushPayloadList) throws APIConnectionException, APIRequestException {
        return this.batchSendPush(this._baseUrl + this.batchRegidPushPath, pushPayloadList);
    }

    public BatchPushResult batchSendPushByAlias(List<PushPayload> pushPayloadList) throws APIConnectionException, APIRequestException {
        return this.batchSendPush(this._baseUrl + this.batchAliasPushPath, pushPayloadList);
    }

    public BatchPushResult batchSendPush(String url, List<PushPayload> pushPayloadList) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != pushPayloadList ? 1 : 0) != 0, (Object)"param should not be null");
        Preconditions.checkArgument((!pushPayloadList.isEmpty() ? 1 : 0) != 0, (Object)"pushPayloadList should not be empty");
        Gson gson = new Gson();
        JsonObject contentJson = new JsonObject();
        CIDResult cidResult = this.getCidList(pushPayloadList.size(), "push");
        int i = 0;
        JsonObject pushPayLoadList = new JsonObject();
        for (PushPayload payload : pushPayloadList) {
            String cid = payload.getCid();
            if (cid != null && !cid.trim().isEmpty()) {
                payload.setCid(null);
            } else {
                cid = cidResult.cidlist.get(i++);
            }
            pushPayLoadList.add(cid, payload.toJSON());
        }
        contentJson.add("pushlist", (JsonElement)pushPayLoadList);
        ResponseWrapper response = this._httpClient.sendPost(url, this.getEncryptData(gson.toJson((JsonElement)contentJson)));
        return BatchPushResult.fromResponse(response);
    }

    public CIDResult getCidList(int count, String type) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((count >= 1 && count <= 1000 ? 1 : 0) != 0, (Object)"count should not less than 1 or larger than 1000");
        Preconditions.checkArgument((type == null || type.equals("push") || type.equals("schedule") ? 1 : 0) != 0, (Object)"type should be \"push\" or \"schedule\"");
        ResponseWrapper responseWrapper = type != null ? this._httpClient.sendGet(this._baseUrl + this._pushPath + "/cid?count=" + count + "&type=" + type) : this._httpClient.sendGet(this._baseUrl + this._pushPath + "/cid?count=" + count);
        return (CIDResult)BaseResult.fromResponse((ResponseWrapper)responseWrapper, CIDResult.class);
    }

    public DefaultResult deletePush(String msgId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)msgId), (Object)"msgId should not be empty");
        ResponseWrapper responseWrapper = this._httpClient.sendDelete(this._baseUrl + this._pushPath + "/" + msgId);
        return DefaultResult.fromResponse((ResponseWrapper)responseWrapper);
    }

    public void setHttpClient(IHttpClient client) {
        this._httpClient = client;
    }

    public void close() {
        if (this._httpClient != null && this._httpClient instanceof NettyHttpClient) {
            ((NettyHttpClient)this._httpClient).close();
        } else if (this._httpClient != null && this._httpClient instanceof ApacheHttpClient) {
            ((ApacheHttpClient)this._httpClient).close();
        }
    }

    private String getEncryptData(String payloadData) {
        JsonElement payloadElement = this._jsonParser.parse(payloadData);
        JsonObject jsonObject = payloadElement.getAsJsonObject();
        Audience audience = Audience.fromJsonElement(jsonObject.get("audience"));
        return this.getEncryptData(payloadData, audience);
    }

    private String getEncryptData(PushPayload pushPayload) {
        if (StringUtils.isEmpty((String)this._encryptType)) {
            return pushPayload.toString();
        }
        if (EncryptKeys.ENCRYPT_SMS2_TYPE.equals(this._encryptType)) {
            EncryptPushPayload encryptPushPayload = new EncryptPushPayload();
            try {
                encryptPushPayload.setPayload(String.valueOf(Base64.encode((byte[])SM2Util.encrypt((String)pushPayload.toString(), (String)EncryptKeys.DEFAULT_SM2_ENCRYPT_KEY))));
            }
            catch (Exception e) {
                throw new RuntimeException("encrypt word exception", e);
            }
            encryptPushPayload.setAudience(pushPayload.getAudience());
            return encryptPushPayload.toString();
        }
        return pushPayload.toString();
    }

    private String getEncryptData(String pushPayload, Audience audience) {
        if (StringUtils.isEmpty((String)this._encryptType)) {
            return pushPayload;
        }
        if (EncryptKeys.ENCRYPT_SMS2_TYPE.equals(this._encryptType)) {
            EncryptPushPayload encryptPushPayload = new EncryptPushPayload();
            try {
                encryptPushPayload.setPayload(String.valueOf(Base64.encode((byte[])SM2Util.encrypt((String)pushPayload, (String)EncryptKeys.DEFAULT_SM2_ENCRYPT_KEY))));
            }
            catch (Exception e) {
                throw new RuntimeException("encrypt word exception", e);
            }
            encryptPushPayload.setAudience(audience);
            return encryptPushPayload.toString();
        }
        return pushPayload;
    }

    private void checkPushPayload(PushPayload pushPayload) {
        Preconditions.checkArgument((null != pushPayload ? 1 : 0) != 0, (Object)"pushPayload should not be null");
        if (this._apnsProduction > 0) {
            pushPayload.resetOptionsApnsProduction(true);
        } else if (this._apnsProduction == 0) {
            pushPayload.resetOptionsApnsProduction(false);
        }
        if (this._timeToLive >= 0L) {
            pushPayload.resetOptionsTimeToLive(this._timeToLive);
        }
    }
}

