/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.schedule.model;

import cn.jpush.api.common.TimeUnit;
import cn.jpush.api.schedule.model.IModel;
import cn.jpush.api.utils.Preconditions;
import cn.jpush.api.utils.StringUtils;
import cn.jpush.api.utils.TimeUtils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public class TriggerPayload
implements IModel {
    private static Gson gson = new Gson();
    private Type type;
    private String start;
    private String end;
    private String time;
    private TimeUnit time_unit;
    private int frequency;
    private String[] point;

    private TriggerPayload(String time) {
        this.type = Type.single;
        this.time = time;
    }

    private TriggerPayload(String start, String end, String time, TimeUnit time_unit, int frequency, String[] point) {
        this.type = Type.periodical;
        this.start = start;
        this.end = end;
        this.time = time;
        this.time_unit = time_unit;
        this.frequency = frequency;
        this.point = point;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        switch (this.type) {
            case single: {
                JsonObject s = new JsonObject();
                s.addProperty("time", this.time);
                json.add(Type.single.name(), (JsonElement)s);
                break;
            }
            case periodical: {
                JsonObject p = new JsonObject();
                p.addProperty("start", this.start);
                p.addProperty("end", this.end);
                p.addProperty("time", this.time);
                p.addProperty("time_unit", this.time_unit.name().toLowerCase());
                p.addProperty("frequency", (Number)this.frequency);
                if (!TimeUnit.DAY.equals((Object)this.time_unit)) {
                    JsonArray array = new JsonArray();
                    for (String aPoint : this.point) {
                        array.add((JsonElement)new JsonPrimitive(aPoint));
                    }
                    p.add("point", (JsonElement)array);
                }
                json.add(Type.periodical.name(), (JsonElement)p);
                break;
            }
        }
        return json;
    }

    public static class Builder {
        private String start;
        private String end;
        private String time;
        private TimeUnit time_unit;
        private int frequency;
        private String[] point;

        public Builder setSingleTime(String time) {
            this.time = time;
            return this;
        }

        public Builder setPeriodTime(String start, String end, String time) {
            this.start = start;
            this.end = end;
            this.time = time;
            return this;
        }

        public Builder setTimeFrequency(TimeUnit time_unit, int frequency, String[] point) {
            this.time_unit = time_unit;
            this.frequency = frequency;
            this.point = point;
            return this;
        }

        public TriggerPayload buildSingle() {
            Preconditions.checkArgument(StringUtils.isNotEmpty(this.time), "The time must not be empty.");
            Preconditions.checkArgument(TimeUtils.isDateFormat(this.time), "The time format is incorrect.");
            return new TriggerPayload(this.time);
        }

        public TriggerPayload buildPeriodical() {
            Preconditions.checkArgument(StringUtils.isNotEmpty(this.start), "The start must not be empty.");
            Preconditions.checkArgument(StringUtils.isNotEmpty(this.end), "The end must not be empty.");
            Preconditions.checkArgument(StringUtils.isNotEmpty(this.time), "The time must not be empty.");
            Preconditions.checkArgument(TimeUtils.isDateFormat(this.start), "The start format is incorrect.");
            Preconditions.checkArgument(TimeUtils.isDateFormat(this.end), "The end format is incorrect.");
            Preconditions.checkArgument(TimeUtils.isTimeFormat(this.time), "The time format is incorrect.");
            Preconditions.checkNotNull(this.time_unit, "The time_unit must not be null.");
            Preconditions.checkArgument(this.isTimeUnitOk(this.time_unit), "The time unit must be DAY, WEEK or MONTH.");
            Preconditions.checkArgument(this.frequency > 0 && this.frequency < 101, "The frequency must be a int between 1 and 100.");
            return new TriggerPayload(this.start, this.end, this.time, this.time_unit, this.frequency, this.point);
        }

        private boolean isTimeUnitOk(TimeUnit timeUnit) {
            switch (timeUnit) {
                case HOUR: {
                    return false;
                }
                case DAY: 
                case WEEK: 
                case MONTH: {
                    return true;
                }
            }
            return false;
        }
    }

    public static enum Type {
        single,
        periodical;

    }
}

