/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.pubsub;

import cn.jmicro.api.JMicroContext;
import cn.jmicro.api.classloader.IClassloaderRpc;
import cn.jmicro.api.classloader.RpcClassLoader;
import cn.jmicro.api.config.Config;
import cn.jmicro.api.monitor.LG;
import cn.jmicro.api.objectfactory.IObjectFactory;
import cn.jmicro.api.registry.IRegistry;
import cn.jmicro.api.registry.IServiceListener;
import cn.jmicro.api.registry.ServiceItem;
import cn.jmicro.api.registry.ServiceMethod;
import cn.jmicro.api.registry.UniqueServiceMethodKey;
import cn.jmicro.api.service.ServiceManager;
import cn.jmicro.common.util.StringUtils;
import cn.jmicro.pubsub.ISubscriberCallback;
import cn.jmicro.pubsub.PubSubServer;
import cn.jmicro.pubsub.SubcribeItem;
import cn.jmicro.pubsub.SubscriberCallbackImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubcriberManager {
    private static final Logger logger = LoggerFactory.getLogger(SubcriberManager.class);
    private boolean openDebug = false;
    private Map<String, ISubscriberCallback> callbacks = new ConcurrentHashMap<String, ISubscriberCallback>();
    private Map<String, Set<ISubscriberCallback>> topic2Callbacks = new ConcurrentHashMap<String, Set<ISubscriberCallback>>();
    private Queue<SubcribeItem> waitingLoadClazz = new ConcurrentLinkedQueue<SubcribeItem>();
    private ClassLoadingWorker clWorker = null;
    private Object loadingLock = new Object();
    private RpcClassLoader cl;
    private IRegistry registry;
    private ServiceManager srvManager;
    private IObjectFactory of;
    private IServiceListener serviceAddedRemoveListener = new IServiceListener(){

        public void serviceChanged(int type, ServiceItem item) {
            if (type == 1) {
                SubcriberManager.this.parseServiceAdded(item);
            } else if (type == 2) {
                SubcriberManager.this.serviceRemoved(item);
            } else if (type == 3) {
                SubcriberManager.this.serviceDataChange(item);
            } else {
                logger.error("rev invalid Node event type : " + type + ",path: " + item.getKey().toKey(true, true, true));
            }
        }
    };

    SubcriberManager(IObjectFactory of, boolean openDebug) {
        this.openDebug = openDebug;
        this.of = of;
        this.cl = (RpcClassLoader)of.get(RpcClassLoader.class);
        this.registry = (IRegistry)of.get(IRegistry.class);
        this.srvManager = (ServiceManager)of.get(ServiceManager.class);
        this.srvManager.addListener(this.serviceAddedRemoveListener);
        this.clWorker = new ClassLoadingWorker();
        this.clWorker.start();
    }

    Set<ISubscriberCallback> getCallback(String topic) {
        return this.topic2Callbacks.get(topic);
    }

    ISubscriberCallback getCallback(ServiceMethod sm) {
        Set<ISubscriberCallback> calls = this.topic2Callbacks.get(sm.getTopic());
        if (calls != null && !calls.isEmpty()) {
            for (ISubscriberCallback c : calls) {
                if (!c.getSm().equals((Object)sm)) continue;
                return c;
            }
        }
        return null;
    }

    boolean isValidTopic(String topic) {
        if (this.topic2Callbacks.containsKey(topic)) {
            return !this.topic2Callbacks.get(topic).isEmpty();
        }
        return false;
    }

    Set<String> topics() {
        return this.topic2Callbacks.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceDataChange(ServiceItem item) {
        if (item == null || item.getMethods() == null) {
            return;
        }
        for (ServiceMethod sm : item.getMethods()) {
            String k = sm.getKey().toKey(false, false, false);
            if (!this.callbacks.containsKey(k) && (this.callbacks.containsKey(k) || !StringUtils.isNotEmpty((String)sm.getTopic()))) continue;
            this.waitingLoadClazz.offer(new SubcribeItem(3, sm.getTopic(), sm, null));
            Object object = this.loadingLock;
            synchronized (object) {
                this.loadingLock.notify();
            }
            if (!this.openDebug) continue;
            logger.debug("Got one CB: {}", (Object)sm.getKey().toKey(true, true, true));
        }
    }

    private void serviceRemoved(ServiceItem item) {
        for (ServiceMethod sm : item.getMethods()) {
            if (StringUtils.isEmpty((String)sm.getTopic())) continue;
            this.unsubcribe(sm.getTopic(), sm, null);
        }
    }

    private void parseServiceAdded(ServiceItem item) {
        if (item == null || item.getMethods() == null) {
            return;
        }
        for (ServiceMethod sm : item.getMethods()) {
            if (StringUtils.isEmpty((String)sm.getTopic())) continue;
            this.subcribe(sm.getTopic(), sm, null);
            if (!this.openDebug) continue;
            logger.debug("Got ont CB: {}", (Object)sm.getKey().toKey(true, true, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean subcribe(String topic, ServiceMethod srvMethod, Map<String, String> context) {
        if (StringUtils.isEmpty((String)topic)) {
            return false;
        }
        String k = srvMethod.getKey().toKey(false, false, false);
        ISubscriberCallback cb = this.callbacks.get(k);
        String[] ts = topic.split(",");
        boolean flag = false;
        for (String t : ts) {
            if (this.topic2Callbacks.get(t) != null && this.topic2Callbacks.get(t).contains(cb)) continue;
            flag = true;
            break;
        }
        if (flag) {
            this.waitingLoadClazz.offer(new SubcribeItem(1, topic, srvMethod, context));
            Object object = this.loadingLock;
            synchronized (object) {
                this.loadingLock.notify();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unsubcribe(String topic, ServiceMethod srvMethod, Map<String, String> context) {
        String k = srvMethod.getKey().toKey(false, false, false);
        if (!this.callbacks.containsKey(k)) {
            return true;
        }
        this.waitingLoadClazz.offer(new SubcribeItem(2, topic, srvMethod, context));
        Object object = this.loadingLock;
        synchronized (object) {
            this.loadingLock.notify();
        }
        return true;
    }

    private boolean doUpdateSubscribe(SubcribeItem sui) {
        String k = sui.sm.getKey().toKey(false, false, false);
        SubscriberCallbackImpl cb = (SubscriberCallbackImpl)this.callbacks.get(k);
        if (cb == null) {
            Set sis = this.registry.getServices(sui.sm.getKey().getServiceName(), sui.sm.getKey().getNamespace(), sui.sm.getKey().getVersion());
            if (sis == null || sis.isEmpty()) {
                logger.warn("Service Item not found {}", (Object)k);
                return false;
            }
            ServiceItem sitem = null;
            for (ServiceItem si : sis) {
                if (!si.getKey().getInstanceName().equals(sui.sm.getKey().getInstanceName())) continue;
                sitem = si;
                break;
            }
            if (sitem == null) {
                logger.warn("Service Item for classloader server not found {}", (Object)sui.sm.getKey().toKey(true, true, true));
                return true;
            }
            Object srv = null;
            try {
                PubSubServer.class.getClassLoader().loadClass(sui.sm.getKey().getUsk().getServiceName());
                srv = this.of.getRemoteServie(sitem, null);
            }
            catch (ClassNotFoundException e) {
                srv = this.getRemoteService(sui, sitem);
            }
            if (srv == null) {
                logger.warn("Servive [" + k + "] not found");
                return false;
            }
            cb = new SubscriberCallbackImpl(sui.sm, srv, this.of);
            cb.init();
            this.callbacks.put(k, cb);
        }
        String[] curTs = null;
        if (StringUtils.isNotEmpty((String)sui.topic)) {
            curTs = sui.topic.split(",");
        }
        HashSet<String> oldTs = new HashSet<String>();
        for (Map.Entry<String, Set<ISubscriberCallback>> e : this.topic2Callbacks.entrySet()) {
            if (!e.getValue().contains(cb)) continue;
            oldTs.add(e.getKey());
        }
        HashSet<String> newTs = new HashSet<String>();
        if (curTs != null) {
            newTs.addAll(Arrays.asList(curTs));
        }
        newTs.removeAll(oldTs);
        if (!newTs.isEmpty()) {
            for (String t : newTs) {
                if (!this.topic2Callbacks.containsKey(t)) {
                    this.topic2Callbacks.put(t, new HashSet());
                }
                if (this.topic2Callbacks.get(t).contains(cb)) continue;
                this.topic2Callbacks.get(t).add(cb);
                if (!this.openDebug) continue;
                logger.debug("subcribe:{},topic:{}", (Object)k, (Object)t);
            }
        }
        newTs.clear();
        if (curTs != null) {
            newTs.addAll(Arrays.asList(curTs));
        }
        oldTs.removeAll(newTs);
        for (String t : oldTs) {
            if (!this.topic2Callbacks.containsKey(t) || !this.topic2Callbacks.get(t).contains(cb)) continue;
            this.topic2Callbacks.get(t).remove(cb);
            if (!this.openDebug) continue;
            logger.debug("unsubcribe:{},topic:{}", (Object)k, (Object)t);
        }
        return true;
    }

    private boolean doSubscribe(SubcribeItem sui) {
        String[] ts;
        String k = sui.sm.getKey().toKey(false, false, false);
        SubscriberCallbackImpl cb = (SubscriberCallbackImpl)this.callbacks.get(k);
        if (cb == null) {
            Set sis = this.registry.getServices(sui.sm.getKey().getServiceName(), sui.sm.getKey().getNamespace(), sui.sm.getKey().getVersion());
            if (sis == null || sis.isEmpty()) {
                logger.warn("Service Item not found {}", (Object)k);
                return false;
            }
            ServiceItem sitem = null;
            for (ServiceItem si : sis) {
                if (!si.getKey().getInstanceName().equals(sui.sm.getKey().getInstanceName())) continue;
                sitem = si;
                break;
            }
            if (sitem == null) {
                logger.warn("Service Item for classloader server not found {}", (Object)sui.sm.getKey().toKey(true, true, true));
                return false;
            }
            Object srv = null;
            try {
                PubSubServer.class.getClassLoader().loadClass(sui.sm.getKey().getUsk().getServiceName());
                srv = this.of.getRemoteServie(sitem, null);
            }
            catch (ClassNotFoundException e) {
                srv = this.getRemoteService(sui, sitem);
            }
            if (srv == null) {
                logger.warn("Servive [" + k + "] not found");
                return false;
            }
            cb = new SubscriberCallbackImpl(sui.sm, srv, this.of);
            cb.init();
            this.callbacks.put(k, cb);
        }
        for (String t : ts = sui.topic.split(",")) {
            if (!this.topic2Callbacks.containsKey(t)) {
                this.topic2Callbacks.put(t, new HashSet());
            }
            if (!this.topic2Callbacks.get(t).contains(cb)) {
                this.topic2Callbacks.get(t).add(cb);
            }
            if (!this.openDebug) continue;
            logger.debug("Subcribe:{},topic:{}", (Object)k, (Object)t);
        }
        return true;
    }

    private ServiceItem getClassLoaderItemByInstanceName(String instanceName) {
        Set items = this.registry.getServices(IClassloaderRpc.class.getName());
        for (ServiceItem si : items) {
            if (!si.getKey().getInstanceName().equals(instanceName)) continue;
            return si;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getRemoteService(SubcribeItem sui, ServiceItem sitem) {
        Object srv;
        block9: {
            ServiceItem oldItem;
            block10: {
                srv = null;
                boolean setDirectServiceItem = false;
                oldItem = null;
                try {
                    ServiceItem clsLoadItem = this.getClassLoaderItemByInstanceName(sitem.getKey().getInstanceName());
                    if (clsLoadItem != null) {
                        oldItem = (ServiceItem)JMicroContext.get().getParam("directServiceItem", null);
                        JMicroContext.get().setParam("directServiceItem", (Object)clsLoadItem);
                        setDirectServiceItem = true;
                        Class cls = this.cl.loadClass(sui.sm.getKey().getUsk().getServiceName());
                        if (cls != null) {
                            srv = this.of.getRemoteServie(sitem, null);
                        }
                    }
                    if (!setDirectServiceItem) break block9;
                    if (oldItem != null) break block10;
                }
                catch (ClassNotFoundException e1) {
                    block11: {
                        try {
                            String k = sui.sm.getKey().toKey(false, false, false);
                            logger.warn("Service {} not found.{}", (Object)k, (Object)e1);
                            LG.log((byte)5, this.getClass(), (String)k, (Throwable)e1);
                            if (!setDirectServiceItem) break block9;
                            if (oldItem != null) break block11;
                        }
                        catch (Throwable throwable) {
                            if (setDirectServiceItem) {
                                if (oldItem == null) {
                                    JMicroContext.get().removeParam("directServiceItem");
                                } else {
                                    JMicroContext.get().setParam("directServiceItem", oldItem);
                                }
                            }
                            throw throwable;
                        }
                        JMicroContext.get().removeParam("directServiceItem");
                    }
                    JMicroContext.get().setParam("directServiceItem", (Object)oldItem);
                }
                JMicroContext.get().removeParam("directServiceItem");
                break block9;
            }
            JMicroContext.get().setParam("directServiceItem", (Object)oldItem);
        }
        return srv;
    }

    private boolean doUnsubcribe(String topic, UniqueServiceMethodKey key, Map<String, String> context) {
        Set sis = this.registry.getServices(key.getServiceName(), key.getNamespace(), key.getVersion());
        if (sis == null || sis.isEmpty()) {
            String[] ts;
            String k = key.toKey(false, false, false);
            if (this.openDebug) {
                logger.debug("Unsubscribe CB:{} topic: {}", (Object)k, (Object)topic);
            }
            ISubscriberCallback cb = this.callbacks.remove(k);
            for (String t : ts = topic.split(",")) {
                Set<ISubscriberCallback> q = this.topic2Callbacks.get(t);
                if (q == null) continue;
                q.remove(cb);
            }
            return cb != null;
        }
        return true;
    }

    private final class ClassLoadingWorker
    extends Thread {
        private Queue<Runnable> tasks;

        public ClassLoadingWorker() {
            super("JMicro-" + Config.getInstanceName() + "-ClassLoadingWorker");
            this.tasks = new ConcurrentLinkedQueue<Runnable>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet<SubcribeItem> failItems = new HashSet<SubcribeItem>();
            this.setContextClassLoader((ClassLoader)SubcriberManager.this.cl);
            block21: while (true) {
                try {
                    if (this.tasks.isEmpty() && SubcriberManager.this.waitingLoadClazz.isEmpty()) {
                        Object object = SubcriberManager.this.loadingLock;
                        synchronized (object) {
                            SubcriberManager.this.loadingLock.wait();
                        }
                    }
                    SubcribeItem si = (SubcribeItem)SubcriberManager.this.waitingLoadClazz.poll();
                    while (si != null) {
                        try {
                            switch (si.type) {
                                case 1: {
                                    if (SubcriberManager.this.doSubscribe(si)) break;
                                    failItems.add(si);
                                    break;
                                }
                                case 2: {
                                    if (SubcriberManager.this.doUnsubcribe(si.topic, si.sm.getKey(), si.context)) break;
                                    failItems.add(si);
                                    break;
                                }
                                case 3: {
                                    if (SubcriberManager.this.doUpdateSubscribe(si)) break;
                                    failItems.add(si);
                                }
                            }
                        }
                        catch (Throwable e) {
                            failItems.add(si);
                            throw e;
                        }
                        si = (SubcribeItem)SubcriberManager.this.waitingLoadClazz.poll();
                    }
                    Runnable psd = this.tasks.poll();
                    while (true) {
                        if (psd == null) continue block21;
                        psd.run();
                        psd = this.tasks.poll();
                    }
                }
                catch (Throwable e) {
                    logger.error("", e);
                    continue;
                }
                finally {
                    boolean needSleep = false;
                    if (!failItems.isEmpty()) {
                        SubcriberManager.this.waitingLoadClazz.addAll(failItems);
                        needSleep = true;
                        failItems.clear();
                    }
                    if (!needSleep) continue;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        logger.error("", (Throwable)e);
                    }
                    continue;
                }
                break;
            }
        }
    }
}

