/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.pubsub;

import cn.jmicro.api.annotation.Component;
import cn.jmicro.api.annotation.Inject;
import cn.jmicro.api.persist.IObjectStorage;
import cn.jmicro.api.profile.ProfileManager;
import cn.jmicro.api.timer.TimerTicker;
import cn.jmicro.api.utils.TimeUtils;
import java.util.Set;
import org.bson.Document;

@Component
public class DataClearWorker {
    @Inject
    private IObjectStorage os;
    @Inject
    private ProfileManager pm;

    public void ready() {
        TimerTicker.doInBaseTicker((int)30, (String)"pubsub-DataClearWorker", null, (key, att) -> {
            this.clearLogData();
            this.clearStatisData();
        });
    }

    private void clearStatisData() {
        Set clientIds = this.os.distinct("t_pubsub_base_data", "clientId", Integer.class);
        if (clientIds == null || clientIds.isEmpty()) {
            return;
        }
        long curTime = TimeUtils.getCurTime();
        Document delFilter = new Document();
        for (Integer cid : clientIds) {
            delFilter.put("clientId", (Object)cid);
            int days = (Integer)this.pm.getVal(cid, "pubsub", "keepTimeLong", (Object)1, Integer.class);
            long time = curTime - (long)(days * 24 * 60 * 60 * 1000);
            delFilter.put("createdTime", (Object)new Document("$lte", (Object)time));
            this.os.deleteByQuery("t_pubsub_base_data", (Object)delFilter);
            this.os.deleteByQuery("t_pubsub_qps_data", (Object)delFilter);
        }
    }

    private void clearLogData() {
        Set clientIds = this.os.distinct("t_pubsub_items", "srcClientId", Integer.class);
        if (clientIds == null || clientIds.isEmpty()) {
            return;
        }
        long curTime = TimeUtils.getCurTime();
        Document delFilter = new Document();
        for (Integer cid : clientIds) {
            delFilter.put("srcClientId", (Object)cid);
            int days = (Integer)this.pm.getVal(cid, "pubsub", "keepTimeLong", (Object)1, Integer.class);
            long time = curTime - (long)(days * 24 * 60 * 60 * 1000);
            delFilter.put("createdTime", (Object)new Document("$lte", (Object)time));
            this.os.deleteByQuery("t_pubsub_items", (Object)delFilter);
        }
    }
}

