/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.pubsub;

import cn.jmicro.api.annotation.Component;
import cn.jmicro.api.annotation.Inject;
import cn.jmicro.api.config.Config;
import cn.jmicro.api.monitor.IMonitorAdapter;
import cn.jmicro.api.monitor.MC;
import cn.jmicro.api.monitor.MonitorClientStatusAdapter;
import cn.jmicro.api.monitor.ServiceCounter;
import cn.jmicro.api.objectfactory.IObjectFactory;
import cn.jmicro.api.persist.IObjectStorage;
import cn.jmicro.api.registry.ServiceItem;
import cn.jmicro.api.service.ServiceLoader;
import cn.jmicro.api.timer.TimerTicker;
import cn.jmicro.api.utils.TimeUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bson.Document;

@Component(level=3)
public class PubsubMessageStatis {
    public static final String KEY_SPERATOR = "##";
    public static final String PUBSUB_BASE_DATA = "t_pubsub_base_data";
    public static final String PUBSUB_TOTAL = "t_pubsub_total";
    public static final String PUBSUB_QPS_DATA = "t_pubsub_qps_data";
    public static final Short[] TYPES = new Short[]{(short)50, (short)55, (short)58, (short)52, (short)64, (short)53, (short)63, (short)66, (short)65, (short)60, (short)61, (short)62, (short)56, (short)59, (short)54};
    public static final String[] typeLabels = new String[TYPES.length];
    private Map<String, ServiceCounter> counters = new HashMap<String, ServiceCounter>();
    private Object syncLock = new Object();
    private MonitorClientStatusAdapter statusMonitorAdapter;
    private long scTimeout = 180000L;
    @Inject
    private IObjectFactory of;
    @Inject
    private IObjectStorage os;

    public void ready() {
        for (int i = 0; i < TYPES.length; ++i) {
            PubsubMessageStatis.typeLabels[i] = (String)MC.MONITOR_VAL_2_KEY.get(TYPES[i]);
        }
        String group = "PubsubServer";
        this.statusMonitorAdapter = new MonitorClientStatusAdapter(TYPES, typeLabels, Config.getInstanceName() + "_PubsubServerStatuCheck", group);
        ServiceLoader sl = (ServiceLoader)this.of.get(ServiceLoader.class);
        ServiceItem si = sl.createSrvItem(IMonitorAdapter.class, Config.getNamespace() + "." + group, "0.0.1", IMonitorAdapter.class.getName(), Config.getClientId());
        this.of.regist("MonitorManagerStatuCheckAdapter", (Object)this.statusMonitorAdapter);
        sl.registService(si, (Object)this.statusMonitorAdapter);
        TimerTicker.doInBaseTicker((int)5, (String)"PubsubMessageStatis-Checker", null, (key, att) -> this.doChecker());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChecker() {
        if (this.counters.isEmpty()) {
            return;
        }
        HashSet<String> temp = new HashSet<String>();
        Object object = this.syncLock;
        synchronized (object) {
            temp.addAll(this.counters.keySet());
        }
        this.clearTimeout(temp);
        if (temp.isEmpty()) {
            return;
        }
        this.saveData(temp);
    }

    private void saveData(Set<String> temp) {
        ArrayList<Document> baseData = new ArrayList<Document>();
        ArrayList<Document> qpsData = new ArrayList<Document>();
        long curTime = TimeUtils.getCurTime();
        Calendar cd = Calendar.getInstance();
        cd.set(11, 0);
        cd.set(12, 0);
        cd.set(13, 0);
        cd.set(14, 0);
        for (String key : temp) {
            ServiceCounter sc = this.counters.get(key);
            if (sc == null) continue;
            String[] arr = key.split(KEY_SPERATOR);
            int id = Integer.parseInt(arr[0]);
            String topic = arr[1];
            Document bd = new Document("clientId", (Object)id).append("createdTime", (Object)curTime).append("topic", (Object)topic);
            Document qd = new Document("clientId", (Object)id).append("createdTime", (Object)curTime).append("topic", (Object)topic);
            Document tdFilter = new Document("clientId", (Object)id).append("topic", (Object)topic).append("createdTime", (Object)cd.getTime().getTime());
            Document td = new Document("updatedTime", (Object)curTime);
            for (int i = 0; i < TYPES.length; ++i) {
                bd.put(typeLabels[i], (Object)sc.get(TYPES[i]));
                qd.put(typeLabels[i], (Object)sc.getQps(TimeUnit.SECONDS, new Short[]{TYPES[i]}));
                td.put(typeLabels[i], (Object)sc.getAndResetTotal(new Short[]{TYPES[i]}));
            }
            baseData.add(bd);
            qpsData.add(qd);
            this.os.update(PUBSUB_TOTAL, (Object)tdFilter, (Object)new Document("$inc", (Object)td), Document.class);
        }
        this.os.save(PUBSUB_BASE_DATA, baseData, Document.class, true, true);
        this.os.save(PUBSUB_QPS_DATA, qpsData, Document.class, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTimeout(Set<String> temp) {
        long curTime = TimeUtils.getCurTime();
        HashSet<String> keys = new HashSet<String>();
        for (String key : temp) {
            ServiceCounter sc = this.counters.get(key);
            if (sc == null || curTime - sc.getLastActiveTime() <= this.scTimeout) continue;
            keys.add(key);
        }
        if (!keys.isEmpty()) {
            Object object = this.syncLock;
            synchronized (object) {
                for (String key : keys) {
                    this.counters.remove(key);
                }
            }
        }
        temp.removeAll(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceCounter getSc(String topic, Integer clientId) {
        String key = clientId + KEY_SPERATOR + topic;
        if (this.counters.containsKey(key)) {
            return this.counters.get(key);
        }
        if (!this.counters.containsKey(key)) {
            Object object = this.syncLock;
            synchronized (object) {
                if (!this.counters.containsKey(key)) {
                    ServiceCounter sc = new ServiceCounter(key, TYPES, 60L, 1L, TimeUnit.SECONDS);
                    this.counters.put(key, sc);
                }
            }
        }
        return this.counters.get(key);
    }
}

