/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.pubsub;

import cn.jmicro.api.cache.ICache;
import cn.jmicro.api.codec.ICodecFactory;
import cn.jmicro.api.objectfactory.IObjectFactory;
import cn.jmicro.common.util.StringUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

class ItemStorage<T> {
    private JedisPool pool;
    private ICodecFactory codeFactory;
    private String prefix;

    ItemStorage(IObjectFactory of, String prefix) {
        this.pool = (JedisPool)of.get(JedisPool.class);
        this.codeFactory = (ICodecFactory)of.get(ICodecFactory.class);
        this.prefix = prefix;
    }

    boolean push(String key, T[] items, int pos, int len) {
        if (items == null) {
            return false;
        }
        for (int i = pos; i < len; ++i) {
            this.push(key, items[i]);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean push(String key, T item) {
        if (item == null) {
            return false;
        }
        try (Jedis j = null;){
            j = this.pool.getResource();
            ByteBuffer bb = (ByteBuffer)this.codeFactory.getEncoder(Byte.valueOf((byte)0)).encode(item);
            if (bb != null) {
                j.lpush(ICache.keyData((String)(this.prefix + key)), (byte[][])new byte[][]{bb.array()});
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long len(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return 0L;
        }
        try (Jedis j = null;){
            j = this.pool.getResource();
            long l = j.llen(ICache.keyData((String)(this.prefix + key)));
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T pop(String key) {
        if (key == null) {
            return null;
        }
        try (Jedis j = null;){
            Object item;
            j = this.pool.getResource();
            byte[] data = j.lpop(ICache.keyData((String)(this.prefix + key)));
            Object object = item = this.codeFactory.getDecoder(Byte.valueOf((byte)0)).decode((Object)ByteBuffer.wrap(data), null);
            return (T)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<T> pops(String key, long size) {
        if (key == null || size <= 0L) {
            return null;
        }
        try (Jedis j = null;){
            byte[] ds;
            ArrayList<Object> l = new ArrayList<Object>();
            j = this.pool.getResource();
            byte[] k = ICache.keyData((String)(this.prefix + key));
            while (size > 0L && (ds = j.lpop(k)) != null) {
                Object item = this.codeFactory.getDecoder(Byte.valueOf((byte)0)).decode((Object)ByteBuffer.wrap(ds), null);
                l.add(item);
            }
            ArrayList<Object> arrayList = l;
            return arrayList;
        }
    }
}

