/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.core.runtime;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Bundle;

public class UriConverter {
    private static UriParseDelegate sUriParseDelegate;

    public static void setUriParseDelegate(UriParseDelegate sUriParseDelegate) {
        UriConverter.sUriParseDelegate = sUriParseDelegate;
    }

    public static Uri parse(String uriString) {
        if (sUriParseDelegate != null) {
            return sUriParseDelegate.parse(uriString);
        }
        return Uri.parse((String)uriString);
    }

    public static Uri parseCall(String uriString, Bundle bundle) {
        if (sUriParseDelegate != null) {
            return sUriParseDelegate.parseCall(uriString, bundle);
        }
        return Uri.parse((String)uriString);
    }

    public static Uri build(Uri.Builder builder) {
        String uri = builder.build().toString();
        return UriConverter.parse(uri);
    }

    public static Bundle call(ContentResolver resolver, Uri uri, String method, String arg, Bundle extras) {
        if (extras == null) {
            extras = new Bundle();
        }
        Uri containerUri = UriConverter.parseCall(uri.toString(), extras);
        return resolver.call(containerUri, method, arg, extras);
    }

    public static void notifyChange(ContentResolver resolver, Uri uri, ContentObserver observer) {
        Uri containerUri = UriConverter.parse(uri.toString());
        resolver.notifyChange(containerUri, observer);
    }

    public static void notifyChange(ContentResolver resolver, Uri uri, ContentObserver observer, boolean syncToNetwork) {
        Uri containerUri = UriConverter.parse(uri.toString());
        resolver.notifyChange(containerUri, observer, syncToNetwork);
    }

    @TargetApi(value=26)
    public static void notifyChange(ContentResolver resolver, Uri uri, ContentObserver observer, int flags) {
        Uri containerUri = UriConverter.parse(uri.toString());
        resolver.notifyChange(containerUri, observer, flags);
    }

    public static interface UriParseDelegate {
        public Uri parse(String var1);

        public Uri parseCall(String var1, Bundle var2);
    }
}

