/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.core.runtime;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewStub;
import com.tencent.shadow.core.runtime.PluginActivity;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public class ShadowFactory2
implements LayoutInflater.Factory2 {
    private String mPartKey;
    private final Object[] mConstructorArgs = new Object[2];
    private final Class<?>[] mConstructorSignature = new Class[]{Context.class, AttributeSet.class};
    private static final HashMap<String, Constructor<? extends View>> sConstructorMap = new HashMap();
    private LayoutInflater mLayoutInflater;
    private static final HashMap<String, String> sCreateSystemMap = new HashMap();
    private static final ClassLoader BOOT_CLASS_LOADER = LayoutInflater.class.getClassLoader();

    public ShadowFactory2(String partKey, LayoutInflater layoutInflater) {
        this.mPartKey = partKey;
        this.mLayoutInflater = layoutInflater;
    }

    public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
        View view;
        if (name.contains(".")) {
            if (sCreateSystemMap.get(name) == null) {
                sCreateSystemMap.put(name, this.mPartKey);
            }
            try {
                view = this.createCustomView(name, context, attrs);
            }
            catch (Exception e) {
                view = null;
            }
        } else {
            view = context instanceof PluginActivity ? ((PluginActivity)context).onCreateView(parent, name, context, attrs) : null;
        }
        return view;
    }

    public View onCreateView(String name, Context context, AttributeSet attrs) {
        return null;
    }

    private View createCustomView(String name, Context context, AttributeSet attrs) {
        String cacheKey = this.mPartKey + name;
        Constructor<? extends View> constructor = sConstructorMap.get(cacheKey);
        if (constructor != null && !this.verifyClassLoader(context, constructor)) {
            constructor = null;
            sConstructorMap.remove(cacheKey);
        }
        Class<View> clazz = null;
        try {
            if (constructor == null) {
                clazz = context.getClassLoader().loadClass(name).asSubclass(View.class);
                constructor = clazz.getConstructor(this.mConstructorSignature);
                constructor.setAccessible(true);
                sConstructorMap.put(cacheKey, constructor);
            }
            Object lastContext = this.mConstructorArgs[0];
            if (this.mConstructorArgs[0] == null) {
                this.mConstructorArgs[0] = context;
            }
            Object[] args = this.mConstructorArgs;
            args[1] = attrs;
            View view = constructor.newInstance(args);
            if (view instanceof ViewStub && Build.VERSION.SDK_INT >= 16) {
                ViewStub viewStub = (ViewStub)view;
                viewStub.setLayoutInflater(this.mLayoutInflater.cloneInContext((Context)args[0]));
            }
            this.mConstructorArgs[0] = lastContext;
            return view;
        }
        catch (Exception e) {
            return null;
        }
    }

    private final boolean verifyClassLoader(Context context, Constructor<? extends View> constructor) {
        ClassLoader constructorLoader = constructor.getDeclaringClass().getClassLoader();
        if (constructorLoader == BOOT_CLASS_LOADER) {
            return true;
        }
        ClassLoader cl = context.getClassLoader();
        do {
            if (constructorLoader != cl) continue;
            return true;
        } while ((cl = cl.getParent()) != null);
        return false;
    }
}

