/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.core.runtime;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Fragment;
import android.app.FragmentManager;
import android.os.Bundle;
import com.tencent.shadow.core.runtime.IContainerFragment;
import com.tencent.shadow.core.runtime.PluginFragmentTransaction;
import com.tencent.shadow.core.runtime.ShadowFragment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PluginFragmentManager {
    FragmentManager mBase;

    PluginFragmentManager(FragmentManager mBase) {
        this.mBase = mBase;
    }

    @SuppressLint(value={"CommitTransaction"})
    public PluginFragmentTransaction beginTransaction() {
        return new PluginFragmentTransaction(this, this.mBase.beginTransaction());
    }

    public ShadowFragment findFragmentByTag(String tag) {
        Fragment fragmentByTag = this.mBase.findFragmentByTag(tag);
        if (fragmentByTag instanceof IContainerFragment) {
            return ((IContainerFragment)fragmentByTag).getPluginFragment();
        }
        return null;
    }

    public boolean executePendingTransactions() {
        return this.mBase.executePendingTransactions();
    }

    @TargetApi(value=26)
    public List<ShadowFragment> getFragments() {
        List containerFragments = this.mBase.getFragments();
        ArrayList<ShadowFragment> pluginFragments = new ArrayList<ShadowFragment>();
        if (containerFragments != null && containerFragments.size() > 0) {
            for (Fragment containerFragment : containerFragments) {
                if (!(containerFragment instanceof IContainerFragment)) continue;
                pluginFragments.add(((IContainerFragment)containerFragment).getPluginFragment());
            }
        }
        return pluginFragments.size() > 0 ? pluginFragments : Collections.EMPTY_LIST;
    }

    public ShadowFragment getFragment(Bundle bundle, String key) {
        Fragment fragment = this.mBase.getFragment(bundle, key);
        return ((IContainerFragment)fragment).getPluginFragment();
    }
}

