/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.core.runtime;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Pair;
import android.view.LayoutInflater;
import com.tencent.shadow.core.runtime.BroadcastReceiverWapper;
import com.tencent.shadow.core.runtime.MixResources;
import com.tencent.shadow.core.runtime.ShadowApplication;
import com.tencent.shadow.core.runtime.ShadowLayoutInflater;
import com.tencent.shadow.core.runtime.SubDirContextThemeWrapper;
import com.tencent.shadow.core.runtime.container.GeneratedHostActivityDelegator;
import com.tencent.shadow.core.runtime.container.HostActivityDelegator;
import java.util.HashMap;
import java.util.Map;

public class ShadowContext
extends SubDirContextThemeWrapper {
    PluginComponentLauncher mPluginComponentLauncher;
    ClassLoader mPluginClassLoader;
    ShadowApplication mShadowApplication;
    Resources mPluginResources;
    Resources mMixResources;
    LayoutInflater mLayoutInflater;
    ApplicationInfo mApplicationInfo;
    protected String mPartKey;
    private String mBusinessName;
    private final Map<BroadcastReceiver, BroadcastReceiverWapper> mBroadcastReceivers = new HashMap<BroadcastReceiver, BroadcastReceiverWapper>();

    public ShadowContext() {
    }

    public ShadowContext(Context base, int themeResId) {
        super(base, themeResId);
    }

    public final void setPluginResources(Resources resources) {
        this.mPluginResources = resources;
    }

    public final void setPluginClassLoader(ClassLoader classLoader) {
        this.mPluginClassLoader = classLoader;
    }

    public void setPluginComponentLauncher(PluginComponentLauncher pluginComponentLauncher) {
        this.mPluginComponentLauncher = pluginComponentLauncher;
    }

    public void setShadowApplication(ShadowApplication shadowApplication) {
        this.mShadowApplication = shadowApplication;
    }

    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        ApplicationInfo copy = new ApplicationInfo(applicationInfo);
        copy.metaData = null;
        this.mApplicationInfo = copy;
    }

    public void setBusinessName(String businessName) {
        if (TextUtils.isEmpty((CharSequence)businessName)) {
            businessName = null;
        }
        this.mBusinessName = businessName;
    }

    public void setPluginPartKey(String partKey) {
        this.mPartKey = partKey;
    }

    public Context getApplicationContext() {
        return this.mShadowApplication;
    }

    public Resources getResources() {
        if (this.mMixResources == null) {
            Context baseContext = this.getBaseContext();
            Resources hostResources = baseContext instanceof HostActivityDelegator ? ((HostActivityDelegator)baseContext).superGetResources() : baseContext.getResources();
            this.mMixResources = new MixResources(hostResources, this.mPluginResources);
        }
        return this.mMixResources;
    }

    public AssetManager getAssets() {
        return this.mPluginResources.getAssets();
    }

    public Object getSystemService(String name) {
        if ("layout_inflater".equals(name)) {
            if (this.mLayoutInflater == null) {
                LayoutInflater inflater = (LayoutInflater)super.getSystemService(name);
                this.mLayoutInflater = ShadowLayoutInflater.build(inflater, (Context)this, this.mPartKey);
            }
            return this.mLayoutInflater;
        }
        return super.getSystemService(name);
    }

    public ClassLoader getClassLoader() {
        return this.mPluginClassLoader;
    }

    public void startActivity(Intent intent) {
        this.startActivity(intent, null);
    }

    public void startActivity(Intent intent, Bundle options) {
        Intent pluginIntent = new Intent(intent);
        pluginIntent.setExtrasClassLoader(this.mPluginClassLoader);
        boolean success = this.mPluginComponentLauncher.startActivity(this, pluginIntent, options);
        if (!success) {
            super.startActivity(intent, options);
        }
    }

    @TargetApi(value=16)
    public void superStartActivity(Intent intent, Bundle options) {
        super.startActivity(intent, options);
    }

    public void unbindService(ServiceConnection conn) {
        if (!((Boolean)this.mPluginComponentLauncher.unbindService((ShadowContext)this, (ServiceConnection)conn).first).booleanValue()) {
            super.unbindService(conn);
        }
    }

    public boolean bindService(Intent service, ServiceConnection conn, int flags) {
        if (service.getComponent() == null) {
            return super.bindService(service, conn, flags);
        }
        Pair<Boolean, Boolean> ret = this.mPluginComponentLauncher.bindService(this, service, conn, flags);
        if (!((Boolean)ret.first).booleanValue()) {
            return super.bindService(service, conn, flags);
        }
        return (Boolean)ret.second;
    }

    public boolean stopService(Intent name) {
        if (name.getComponent() == null) {
            return super.stopService(name);
        }
        Pair<Boolean, Boolean> ret = this.mPluginComponentLauncher.stopService(this, name);
        if (!((Boolean)ret.first).booleanValue()) {
            return super.stopService(name);
        }
        return (Boolean)ret.second;
    }

    public ComponentName startService(Intent service) {
        if (service.getComponent() == null) {
            return super.startService(service);
        }
        Pair<Boolean, ComponentName> ret = this.mPluginComponentLauncher.startService(this, service);
        if (!((Boolean)ret.first).booleanValue()) {
            return super.startService(service);
        }
        return (ComponentName)ret.second;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.mApplicationInfo;
    }

    public PluginComponentLauncher getPendingIntentConverter() {
        return this.mPluginComponentLauncher;
    }

    @Override
    String getSubDirName() {
        if (this.mBusinessName == null) {
            return null;
        }
        return "ShadowPlugin_" + this.mBusinessName;
    }

    public String getPackageName() {
        return this.mApplicationInfo.packageName;
    }

    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        return super.registerReceiver((BroadcastReceiver)this.wrapBroadcastReceiver(receiver), filter);
    }

    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter, int flags) {
        return super.registerReceiver((BroadcastReceiver)this.wrapBroadcastReceiver(receiver), filter, flags);
    }

    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter, String broadcastPermission, Handler scheduler) {
        return super.registerReceiver((BroadcastReceiver)this.wrapBroadcastReceiver(receiver), filter, broadcastPermission, scheduler);
    }

    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter, String broadcastPermission, Handler scheduler, int flags) {
        return super.registerReceiver((BroadcastReceiver)this.wrapBroadcastReceiver(receiver), filter, broadcastPermission, scheduler, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterReceiver(BroadcastReceiver receiver) {
        Map<BroadcastReceiver, BroadcastReceiverWapper> map = this.mBroadcastReceivers;
        synchronized (map) {
            BroadcastReceiverWapper broadcastReceiverWapper = this.mBroadcastReceivers.get(receiver);
            if (broadcastReceiverWapper != null) {
                super.unregisterReceiver((BroadcastReceiver)broadcastReceiverWapper);
            } else {
                super.unregisterReceiver(receiver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BroadcastReceiverWapper wrapBroadcastReceiver(BroadcastReceiver receiver) {
        Map<BroadcastReceiver, BroadcastReceiverWapper> map = this.mBroadcastReceivers;
        synchronized (map) {
            BroadcastReceiverWapper broadcastReceiverWapper = this.mBroadcastReceivers.get(receiver);
            if (broadcastReceiverWapper == null) {
                broadcastReceiverWapper = new BroadcastReceiverWapper(receiver, this);
            }
            this.mBroadcastReceivers.put(receiver, broadcastReceiverWapper);
            return broadcastReceiverWapper;
        }
    }

    public static interface PluginComponentLauncher {
        public boolean startActivity(ShadowContext var1, Intent var2, Bundle var3);

        public boolean startActivityForResult(GeneratedHostActivityDelegator var1, Intent var2, int var3, Bundle var4, ComponentName var5);

        public Pair<Boolean, ComponentName> startService(ShadowContext var1, Intent var2);

        public Pair<Boolean, Boolean> stopService(ShadowContext var1, Intent var2);

        public Pair<Boolean, Boolean> bindService(ShadowContext var1, Intent var2, ServiceConnection var3, int var4);

        public Pair<Boolean, ?> unbindService(ShadowContext var1, ServiceConnection var2);

        public Intent convertPluginActivityIntent(Intent var1);
    }
}

