/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.core.runtime;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.IntentFilter;
import android.content.res.Configuration;
import com.tencent.shadow.core.runtime.ShadowActivityLifecycleCallbacks;
import com.tencent.shadow.core.runtime.ShadowAppComponentFactory;
import com.tencent.shadow.core.runtime.ShadowContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShadowApplication
extends ShadowContext {
    private Application mHostApplication;
    private Map<String, List<String>> mBroadcasts;
    private ShadowAppComponentFactory mAppComponentFactory;
    public boolean isCallOnCreate;
    private final Map<ShadowActivityLifecycleCallbacks, Application.ActivityLifecycleCallbacks> mActivityLifecycleCallbacksMap = new HashMap<ShadowActivityLifecycleCallbacks, Application.ActivityLifecycleCallbacks>();

    @Override
    public Context getApplicationContext() {
        return this;
    }

    public void onCreate() {
        this.isCallOnCreate = true;
        for (Map.Entry<String, List<String>> entry : this.mBroadcasts.entrySet()) {
            try {
                Class<?> clazz = this.mPluginClassLoader.loadClass(entry.getKey());
                BroadcastReceiver receiver = (BroadcastReceiver)clazz.newInstance();
                this.mAppComponentFactory.instantiateReceiver(this.mPluginClassLoader, entry.getKey(), null);
                IntentFilter intentFilter = new IntentFilter();
                for (String action : entry.getValue()) {
                    intentFilter.addAction(action);
                }
                this.registerReceiver(receiver, intentFilter);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.mHostApplication.registerComponentCallbacks((ComponentCallbacks)new ComponentCallbacks2(){

            public void onTrimMemory(int level) {
                ShadowApplication.this.onTrimMemory(level);
            }

            public void onConfigurationChanged(Configuration newConfig) {
                ShadowApplication.this.onConfigurationChanged(newConfig);
            }

            public void onLowMemory() {
                ShadowApplication.this.onLowMemory();
            }
        });
    }

    public void onTerminate() {
        throw new UnsupportedOperationException();
    }

    public void onConfigurationChanged(Configuration newConfig) {
    }

    public void onLowMemory() {
    }

    public void onTrimMemory(int level) {
    }

    public void registerComponentCallbacks(ComponentCallbacks callback) {
        this.mHostApplication.registerComponentCallbacks(callback);
    }

    public void unregisterComponentCallbacks(ComponentCallbacks callback) {
        this.mHostApplication.unregisterComponentCallbacks(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerActivityLifecycleCallbacks(ShadowActivityLifecycleCallbacks callback) {
        Map<ShadowActivityLifecycleCallbacks, Application.ActivityLifecycleCallbacks> map = this.mActivityLifecycleCallbacksMap;
        synchronized (map) {
            ShadowActivityLifecycleCallbacks.Wrapper wrapper = new ShadowActivityLifecycleCallbacks.Wrapper(callback, (Object)this);
            this.mActivityLifecycleCallbacksMap.put(callback, wrapper);
            this.mHostApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterActivityLifecycleCallbacks(ShadowActivityLifecycleCallbacks callback) {
        Map<ShadowActivityLifecycleCallbacks, Application.ActivityLifecycleCallbacks> map = this.mActivityLifecycleCallbacksMap;
        synchronized (map) {
            Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = this.mActivityLifecycleCallbacksMap.get(callback);
            if (activityLifecycleCallbacks != null) {
                this.mHostApplication.unregisterActivityLifecycleCallbacks(activityLifecycleCallbacks);
                this.mActivityLifecycleCallbacksMap.remove(callback);
            }
        }
    }

    @TargetApi(value=18)
    public void registerOnProvideAssistDataListener(Application.OnProvideAssistDataListener callback) {
        this.mHostApplication.registerOnProvideAssistDataListener(callback);
    }

    @TargetApi(value=18)
    public void unregisterOnProvideAssistDataListener(Application.OnProvideAssistDataListener callback) {
        this.mHostApplication.unregisterOnProvideAssistDataListener(callback);
    }

    public void setHostApplicationContextAsBase(Context hostAppContext) {
        super.attachBaseContext(hostAppContext);
        this.mHostApplication = (Application)hostAppContext;
    }

    public void setBroadcasts(Map<String, List<String>> broadcast) {
        this.mBroadcasts = broadcast;
    }

    public void attachBaseContext(Context base) {
    }

    public void setAppComponentFactory(ShadowAppComponentFactory factory) {
        this.mAppComponentFactory = factory;
    }
}

