/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.core.runtime;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.tencent.shadow.core.runtime.PluginActivity;
import com.tencent.shadow.core.runtime.ShadowActivity;
import com.tencent.shadow.core.runtime.container.PluginContainerActivity;

public interface ShadowActivityLifecycleCallbacks {
    public void onActivityCreated(ShadowActivity var1, Bundle var2);

    public void onActivityStarted(ShadowActivity var1);

    public void onActivityResumed(ShadowActivity var1);

    public void onActivityPaused(ShadowActivity var1);

    public void onActivityStopped(ShadowActivity var1);

    public void onActivitySaveInstanceState(ShadowActivity var1, Bundle var2);

    public void onActivityDestroyed(ShadowActivity var1);

    public static class Wrapper
    implements Application.ActivityLifecycleCallbacks {
        final ShadowActivityLifecycleCallbacks shadowActivityLifecycleCallbacks;
        final Object runtimeObject;

        public Wrapper(ShadowActivityLifecycleCallbacks shadowActivityLifecycleCallbacks, Object runtimeObject) {
            this.shadowActivityLifecycleCallbacks = shadowActivityLifecycleCallbacks;
            this.runtimeObject = runtimeObject;
        }

        private ShadowActivity getPluginActivity(Activity activity) {
            if (activity instanceof PluginContainerActivity) {
                return (ShadowActivity)PluginActivity.get((PluginContainerActivity)activity);
            }
            return null;
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            ShadowActivity pluginActivity = this.getPluginActivity(activity);
            if (this.checkOwnerActivity(pluginActivity)) {
                this.shadowActivityLifecycleCallbacks.onActivityCreated(pluginActivity, savedInstanceState);
            }
        }

        public void onActivityStarted(Activity activity) {
            ShadowActivity pluginActivity = this.getPluginActivity(activity);
            if (this.checkOwnerActivity(pluginActivity)) {
                this.shadowActivityLifecycleCallbacks.onActivityStarted(pluginActivity);
            }
        }

        public void onActivityResumed(Activity activity) {
            ShadowActivity pluginActivity = this.getPluginActivity(activity);
            if (this.checkOwnerActivity(pluginActivity)) {
                this.shadowActivityLifecycleCallbacks.onActivityResumed(pluginActivity);
            }
        }

        public void onActivityPaused(Activity activity) {
            ShadowActivity pluginActivity = this.getPluginActivity(activity);
            if (this.checkOwnerActivity(pluginActivity)) {
                this.shadowActivityLifecycleCallbacks.onActivityPaused(pluginActivity);
            }
        }

        public void onActivityStopped(Activity activity) {
            ShadowActivity pluginActivity = this.getPluginActivity(activity);
            if (this.checkOwnerActivity(pluginActivity)) {
                this.shadowActivityLifecycleCallbacks.onActivityStopped(pluginActivity);
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            ShadowActivity pluginActivity = this.getPluginActivity(activity);
            if (this.checkOwnerActivity(pluginActivity)) {
                this.shadowActivityLifecycleCallbacks.onActivitySaveInstanceState(pluginActivity, outState);
            }
        }

        public void onActivityDestroyed(Activity activity) {
            ShadowActivity pluginActivity = this.getPluginActivity(activity);
            if (this.checkOwnerActivity(pluginActivity)) {
                this.shadowActivityLifecycleCallbacks.onActivityDestroyed(pluginActivity);
            }
        }

        private boolean checkOwnerActivity(PluginActivity activity) {
            return activity != null && activity.mPluginApplication == this.runtimeObject;
        }
    }
}

