/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.core.runtime;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.view.ContextThemeWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

abstract class SubDirContextThemeWrapper
extends ContextThemeWrapper {
    private final Object mSync = new Object();
    private File mDataDir;
    private File mFilesDir;
    private File mNoBackupFilesDir;
    private File mObbDir;
    private File mCacheDir;
    private File mCodeCacheDir;
    private File mExternalCacheDir;

    abstract String getSubDirName();

    public SubDirContextThemeWrapper() {
    }

    public SubDirContextThemeWrapper(Context base, int themeResId) {
        super(base, themeResId);
    }

    @TargetApi(value=23)
    public SubDirContextThemeWrapper(Context base, Resources.Theme theme) {
        super(base, theme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getDataDir() {
        if (this.getSubDirName() == null) {
            return super.getDataDir();
        }
        Object object = this.mSync;
        synchronized (object) {
            if (this.mDataDir == null) {
                this.mDataDir = new File(super.getDataDir(), this.getSubDirName());
            }
            return SubDirContextThemeWrapper.ensurePrivateDirExists(this.mDataDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFilesDir() {
        if (this.getSubDirName() == null) {
            return super.getFilesDir();
        }
        Object object = this.mSync;
        synchronized (object) {
            if (this.mFilesDir == null) {
                this.mFilesDir = new File(super.getFilesDir(), this.getSubDirName());
            }
            return SubDirContextThemeWrapper.ensurePrivateDirExists(this.mFilesDir);
        }
    }

    public FileInputStream openFileInput(String name) throws FileNotFoundException {
        if (this.getSubDirName() == null) {
            return super.openFileInput(name);
        }
        File f = SubDirContextThemeWrapper.makeFilename(this.getFilesDir(), name);
        return new FileInputStream(f);
    }

    public FileOutputStream openFileOutput(String name, int mode) throws FileNotFoundException {
        if (mode != 0 || this.getSubDirName() == null) {
            return super.openFileOutput(name, mode);
        }
        boolean append = (mode & 0x8000) != 0;
        File f = SubDirContextThemeWrapper.makeFilename(this.getFilesDir(), name);
        return new FileOutputStream(f, append);
    }

    public boolean deleteFile(String name) {
        File f = SubDirContextThemeWrapper.makeFilename(this.getFilesDir(), name);
        return f.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getNoBackupFilesDir() {
        if (this.getSubDirName() == null) {
            return super.getNoBackupFilesDir();
        }
        Object object = this.mSync;
        synchronized (object) {
            if (this.mNoBackupFilesDir == null) {
                this.mNoBackupFilesDir = new File(super.getNoBackupFilesDir(), this.getSubDirName());
            }
            return SubDirContextThemeWrapper.ensurePrivateDirExists(this.mNoBackupFilesDir);
        }
    }

    public File getExternalFilesDir(String type) {
        if (this.getSubDirName() == null) {
            return super.getExternalFilesDir(type);
        }
        return SubDirContextThemeWrapper.ensurePrivateDirExists(new File(super.getExternalFilesDir(type), this.getSubDirName()));
    }

    public File[] getExternalFilesDirs(String type) {
        if (this.getSubDirName() == null) {
            return super.getExternalFilesDirs(type);
        }
        File[] superResult = super.getExternalFilesDirs(type);
        File[] result = new File[superResult.length];
        for (int i = 0; i < superResult.length; ++i) {
            result[i] = SubDirContextThemeWrapper.ensurePrivateDirExists(new File(superResult[i], this.getSubDirName()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getObbDir() {
        if (this.getSubDirName() == null) {
            return super.getObbDir();
        }
        Object object = this.mSync;
        synchronized (object) {
            if (this.mObbDir == null) {
                this.mObbDir = new File(super.getObbDir(), this.getSubDirName());
            }
            return SubDirContextThemeWrapper.ensurePrivateDirExists(this.mObbDir);
        }
    }

    public File[] getObbDirs() {
        if (this.getSubDirName() == null) {
            return super.getObbDirs();
        }
        File[] superResult = super.getObbDirs();
        File[] result = new File[superResult.length];
        for (int i = 0; i < superResult.length; ++i) {
            result[i] = SubDirContextThemeWrapper.ensurePrivateDirExists(new File(superResult[i], this.getSubDirName()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getCacheDir() {
        if (this.getSubDirName() == null) {
            return super.getCacheDir();
        }
        Object object = this.mSync;
        synchronized (object) {
            if (this.mCacheDir == null) {
                this.mCacheDir = new File(super.getCacheDir(), this.getSubDirName());
            }
            return SubDirContextThemeWrapper.ensurePrivateDirExists(this.mCacheDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getCodeCacheDir() {
        if (this.getSubDirName() == null) {
            return super.getCodeCacheDir();
        }
        Object object = this.mSync;
        synchronized (object) {
            if (this.mCodeCacheDir == null) {
                this.mCodeCacheDir = new File(super.getCodeCacheDir(), this.getSubDirName());
            }
            return SubDirContextThemeWrapper.ensurePrivateDirExists(this.mCodeCacheDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getExternalCacheDir() {
        if (this.getSubDirName() == null) {
            return super.getExternalCacheDir();
        }
        Object object = this.mSync;
        synchronized (object) {
            if (this.mExternalCacheDir == null) {
                this.mExternalCacheDir = new File(super.getExternalCacheDir(), this.getSubDirName());
            }
            return SubDirContextThemeWrapper.ensurePrivateDirExists(this.mExternalCacheDir);
        }
    }

    public File[] getExternalCacheDirs() {
        if (this.getSubDirName() == null) {
            return super.getExternalCacheDirs();
        }
        File[] superResult = super.getExternalCacheDirs();
        File[] result = new File[superResult.length];
        for (int i = 0; i < superResult.length; ++i) {
            result[i] = SubDirContextThemeWrapper.ensurePrivateDirExists(new File(superResult[i], this.getSubDirName()));
        }
        return result;
    }

    public File[] getExternalMediaDirs() {
        if (this.getSubDirName() == null) {
            return super.getExternalMediaDirs();
        }
        File[] superResult = super.getExternalMediaDirs();
        File[] result = new File[superResult.length];
        for (int i = 0; i < superResult.length; ++i) {
            result[i] = SubDirContextThemeWrapper.ensurePrivateDirExists(new File(superResult[i], this.getSubDirName()));
        }
        return result;
    }

    public File getDir(String name, int mode) {
        if (mode != 0 || this.getSubDirName() == null) {
            return super.getDir(name, mode);
        }
        return SubDirContextThemeWrapper.ensurePrivateDirExists(new File(super.getDir(name, mode), this.getSubDirName()));
    }

    public SharedPreferences getSharedPreferences(String name, int mode) {
        if (mode != 0 || this.getSubDirName() == null) {
            return super.getSharedPreferences(name, mode);
        }
        return super.getSharedPreferences(this.makeSubName(name), mode);
    }

    public boolean deleteSharedPreferences(String name) {
        if (this.getSubDirName() == null) {
            return super.deleteSharedPreferences(name);
        }
        return super.deleteSharedPreferences(this.makeSubName(name));
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory) {
        if (mode != 0 || this.getSubDirName() == null) {
            return super.openOrCreateDatabase(name, mode, factory);
        }
        return super.openOrCreateDatabase(this.makeSubName(name), mode, factory);
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory, DatabaseErrorHandler errorHandler) {
        if (mode != 0 || this.getSubDirName() == null) {
            return super.openOrCreateDatabase(name, mode, factory, errorHandler);
        }
        return super.openOrCreateDatabase(this.makeSubName(name), mode, factory, errorHandler);
    }

    public boolean moveDatabaseFrom(Context sourceContext, String name) {
        if (this.getSubDirName() == null) {
            return super.moveDatabaseFrom(sourceContext, name);
        }
        throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301");
    }

    public boolean deleteDatabase(String name) {
        if (this.getSubDirName() == null) {
            return super.deleteDatabase(name);
        }
        return super.deleteDatabase(this.makeSubName(name));
    }

    public File getDatabasePath(String name) {
        if (this.getSubDirName() == null) {
            return super.getDatabasePath(name);
        }
        return super.getDatabasePath(this.makeSubName(name));
    }

    public String[] databaseList() {
        if (this.getSubDirName() == null) {
            return super.databaseList();
        }
        String[] databaseList = super.databaseList();
        boolean[] record = new boolean[databaseList.length];
        int size = 0;
        for (int i = 0; i < databaseList.length; ++i) {
            if (databaseList[i].startsWith(this.getSubDirName())) {
                record[i] = true;
                ++size;
                continue;
            }
            record[i] = false;
        }
        String[] result = new String[size];
        int j = 0;
        for (int i = 0; i < record.length; ++i) {
            if (!record[i]) continue;
            result[j++] = databaseList[i];
        }
        return result;
    }

    private String makeSubName(String name) {
        return this.getSubDirName() + "_" + name;
    }

    private static File ensurePrivateDirExists(File dir) {
        dir.mkdirs();
        return dir;
    }

    private static File makeFilename(File base, String name) {
        if (name.indexOf(File.separatorChar) < 0) {
            return new File(base, name);
        }
        throw new IllegalArgumentException("File " + name + " contains a path separator");
    }
}

