/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.core.runtime;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Message;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.webkit.ClientCertRequest;
import android.webkit.HttpAuthHandler;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.SafeBrowsingResponse;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.io.IOException;

public class ShadowWebView
extends WebView {
    private Context mContext;
    private final String ANDROID_ASSET_PREFIX = "file:///android_asset/";
    private final String REPLACE_ASSET_PREFIX = "http://android.asset/";

    public ShadowWebView(Context context) {
        super(context);
        this.init(context);
    }

    public ShadowWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ShadowWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @TargetApi(value=21)
    public ShadowWebView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    public ShadowWebView(Context context, AttributeSet attrs, int defStyleAttr, boolean privateBrowsing) {
        super(context, attrs, defStyleAttr, privateBrowsing);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.setWebViewClient(new WebViewClient());
    }

    public void loadUrl(String url) {
        if (url.startsWith("file:///android_asset/")) {
            url = url.replace("file:///android_asset/", "http://android.asset/");
        }
        super.loadUrl(url);
    }

    public void setWebViewClient(WebViewClient client) {
        super.setWebViewClient((WebViewClient)new WarpWebViewClient(client, this.mContext));
    }

    class WarpWebViewClient
    extends WebViewClient {
        private WebViewClient mWebViewClient;
        private Context mContext;

        public WarpWebViewClient(WebViewClient webViewClient, Context context) {
            this.mWebViewClient = webViewClient;
            this.mContext = context;
        }

        private WebResourceResponse getInterceptResponse(String url) {
            if (url.startsWith("http://android.asset/")) {
                int end = url.indexOf("?");
                if (end == -1) {
                    end = url.length();
                }
                String filePath = url.substring("http://android.asset/".length(), end);
                String mime = "text/html";
                if (filePath.contains(".css")) {
                    mime = "text/css";
                } else if (filePath.contains(".js")) {
                    mime = "application/x-javascript";
                } else if (filePath.contains(".jpg") || filePath.contains(".gif") || filePath.contains(".png") || filePath.contains(".jpeg")) {
                    mime = "image/*";
                }
                try {
                    return new WebResourceResponse(mime, "utf-8", this.mContext.getAssets().open(filePath));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return this.mWebViewClient.shouldOverrideUrlLoading(view, url);
        }

        @TargetApi(value=24)
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            return this.mWebViewClient.shouldOverrideUrlLoading(view, request);
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            this.mWebViewClient.onPageStarted(view, url, favicon);
        }

        public void onPageFinished(WebView view, String url) {
            this.mWebViewClient.onPageFinished(view, url);
        }

        public void onLoadResource(WebView view, String url) {
            this.mWebViewClient.onLoadResource(view, url);
        }

        @TargetApi(value=23)
        public void onPageCommitVisible(WebView view, String url) {
            this.mWebViewClient.onPageCommitVisible(view, url);
        }

        public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
            WebResourceResponse resourceResponse = this.getInterceptResponse(url);
            if (resourceResponse != null) {
                return resourceResponse;
            }
            return this.mWebViewClient.shouldInterceptRequest(view, url);
        }

        @TargetApi(value=21)
        public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
            String url = request.getUrl().toString();
            WebResourceResponse resourceResponse = this.getInterceptResponse(url);
            if (resourceResponse != null) {
                return resourceResponse;
            }
            return this.mWebViewClient.shouldInterceptRequest(view, request);
        }

        public void onTooManyRedirects(WebView view, Message cancelMsg, Message continueMsg) {
            this.mWebViewClient.onTooManyRedirects(view, cancelMsg, continueMsg);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            this.mWebViewClient.onReceivedError(view, errorCode, description, failingUrl);
        }

        @TargetApi(value=23)
        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            this.mWebViewClient.onReceivedError(view, request, error);
        }

        @TargetApi(value=23)
        public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
            this.mWebViewClient.onReceivedHttpError(view, request, errorResponse);
        }

        public void onFormResubmission(WebView view, Message dontResend, Message resend) {
            this.mWebViewClient.onFormResubmission(view, dontResend, resend);
        }

        public void doUpdateVisitedHistory(WebView view, String url, boolean isReload) {
            this.mWebViewClient.doUpdateVisitedHistory(view, url, isReload);
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            this.mWebViewClient.onReceivedSslError(view, handler, error);
        }

        @TargetApi(value=21)
        public void onReceivedClientCertRequest(WebView view, ClientCertRequest request) {
            this.mWebViewClient.onReceivedClientCertRequest(view, request);
        }

        public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
            this.mWebViewClient.onReceivedHttpAuthRequest(view, handler, host, realm);
        }

        public boolean shouldOverrideKeyEvent(WebView view, KeyEvent event) {
            return this.mWebViewClient.shouldOverrideKeyEvent(view, event);
        }

        public void onUnhandledKeyEvent(WebView view, KeyEvent event) {
            this.mWebViewClient.onUnhandledKeyEvent(view, event);
        }

        public void onScaleChanged(WebView view, float oldScale, float newScale) {
            this.mWebViewClient.onScaleChanged(view, oldScale, newScale);
        }

        public void onReceivedLoginRequest(WebView view, String realm, String account, String args) {
            this.mWebViewClient.onReceivedLoginRequest(view, realm, account, args);
        }

        @TargetApi(value=26)
        public boolean onRenderProcessGone(WebView view, RenderProcessGoneDetail detail) {
            return this.mWebViewClient.onRenderProcessGone(view, detail);
        }

        @TargetApi(value=27)
        public void onSafeBrowsingHit(WebView view, WebResourceRequest request, int threatType, SafeBrowsingResponse callback) {
            this.mWebViewClient.onSafeBrowsingHit(view, request, threatType, callback);
        }
    }
}

