/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.core.runtime;

import android.animation.Animator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.LoaderManager;
import android.app.SharedElementCallback;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Bundle;
import android.transition.Transition;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.tencent.shadow.core.runtime.IContainerFragment;
import com.tencent.shadow.core.runtime.PluginActivity;
import com.tencent.shadow.core.runtime.PluginFragmentManager;
import com.tencent.shadow.core.runtime.ShadowActivity;
import com.tencent.shadow.core.runtime.container.PluginContainerActivity;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class ShadowFragment {
    private static Map<String, Constructor<?>> constructorMap = new HashMap();
    protected boolean mIsAppCreateFragment;
    PluginFragmentManager mPluginFragmentManager;
    private Context mAttachedContext;
    protected IContainerFragment mContainerFragment = ShadowFragment.instantiateContainerFragment(this);
    private int mChildPluginFragmentManagerHash;
    private PluginFragmentManager mChildPluginFragmentManager;

    private static IContainerFragment instantiateContainerFragment(ShadowFragment shadowFragment) {
        String shadowFragmentClassname = shadowFragment.getClass().getName();
        String containerFragmentClassName = shadowFragmentClassname.substring(0, shadowFragmentClassname.length() - 1);
        Constructor<?> constructor = constructorMap.get(containerFragmentClassName);
        if (constructor == null) {
            ClassLoader pluginClassLoader = shadowFragment.getClass().getClassLoader();
            try {
                Class<?> aClass = pluginClassLoader.loadClass(containerFragmentClassName);
                constructor = aClass.getConstructor(new Class[0]);
                constructorMap.put(containerFragmentClassName, constructor);
            }
            catch (Exception e) {
                throw new Fragment.InstantiationException("\u65e0\u6cd5\u6784\u9020" + containerFragmentClassName, e);
            }
        }
        try {
            return (IContainerFragment)IContainerFragment.class.cast(constructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new Fragment.InstantiationException("\u65e0\u6cd5\u6784\u9020" + containerFragmentClassName, e);
        }
    }

    public ShadowFragment() {
        this.mContainerFragment.bindPluginFragment(this);
        this.mIsAppCreateFragment = true;
    }

    public void setContainerFragment(IContainerFragment containerFragment) {
        this.mIsAppCreateFragment = false;
        this.mContainerFragment.unbindPluginFragment();
        this.mContainerFragment = containerFragment;
    }

    public IContainerFragment getContainerFragment() {
        if (this.mContainerFragment == null) {
            throw new NullPointerException(this.getClass().getName() + " mContainerFragment == null");
        }
        return this.mContainerFragment;
    }

    public final ShadowActivity getActivity() {
        if (this.mAttachedContext == null) {
            return null;
        }
        if (this.mAttachedContext instanceof ShadowActivity) {
            return (ShadowActivity)this.mAttachedContext;
        }
        PluginContainerActivity activity = (PluginContainerActivity)this.mContainerFragment.getActivity();
        return (ShadowActivity)PluginActivity.get(activity);
    }

    public void setArguments(Bundle args) {
        if (this.mIsAppCreateFragment) {
            this.mContainerFragment.setArguments(args);
        }
    }

    public final Bundle getArguments() {
        return this.mContainerFragment.getArguments();
    }

    public PluginFragmentManager getFragmentManager() {
        if (this.mPluginFragmentManager == null && this.getActivity() != null) {
            this.mPluginFragmentManager = this.getActivity().getFragmentManager();
        }
        return this.mPluginFragmentManager;
    }

    public PluginFragmentManager getChildFragmentManager() {
        FragmentManager fragmentManager = this.mContainerFragment.getChildFragmentManager();
        int hash = System.identityHashCode(fragmentManager);
        if (hash != this.mChildPluginFragmentManagerHash) {
            this.mChildPluginFragmentManagerHash = hash;
            this.mChildPluginFragmentManager = new PluginFragmentManager(fragmentManager);
        }
        return this.mChildPluginFragmentManager;
    }

    public final Resources getResources() {
        if (this.mAttachedContext == null) {
            throw new IllegalStateException("Fragment " + this + " not attached to Activity");
        }
        return this.mAttachedContext.getResources();
    }

    public void setInitialSavedState(Fragment.SavedState state) {
    }

    public void setTargetFragment(Fragment fragment, int requestCode) {
    }

    public Context getContext() {
        return this.mAttachedContext;
    }

    public void onHiddenChanged(boolean hidden) {
        this.mContainerFragment.superOnHiddenChanged(hidden);
    }

    public void setRetainInstance(boolean retain) {
        this.mContainerFragment.superSetRetainInstance(retain);
    }

    public void setHasOptionsMenu(boolean hasMenu) {
        this.mContainerFragment.superSetHasOptionsMenu(hasMenu);
    }

    public void setMenuVisibility(boolean menuVisible) {
        this.mContainerFragment.superSetMenuVisibility(menuVisible);
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        this.mContainerFragment.superSetUserVisibleHint(isVisibleToUser);
    }

    public boolean getUserVisibleHint() {
        return this.mContainerFragment.getUserVisibleHint();
    }

    public LoaderManager getLoaderManager() {
        return null;
    }

    public void startActivity(Intent intent) {
        this.mAttachedContext.startActivity(intent);
    }

    @TargetApi(value=16)
    public void startActivity(Intent intent, Bundle options) {
        this.mAttachedContext.startActivity(intent, options);
    }

    public void startActivityForResult(Intent intent, int requestCode) {
    }

    public void startActivityForResult(Intent intent, int requestCode, Bundle options) {
    }

    public void startIntentSenderForResult(IntentSender intent, int requestCode, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) throws IntentSender.SendIntentException {
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
    }

    public boolean shouldShowRequestPermissionRationale(String permission) {
        return false;
    }

    public LayoutInflater onGetLayoutInflater(Bundle savedInstanceState) {
        return null;
    }

    public void onInflate(AttributeSet attrs, Bundle savedInstanceState) {
    }

    public void onInflate(Context context, AttributeSet attrs, Bundle savedInstanceState) {
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
    }

    public void onAttachFragment(Fragment childFragment) {
    }

    public void onAttach(Context context) {
        this.mAttachedContext = context;
    }

    public void onAttach(ShadowActivity activity) {
        this.mAttachedContext = activity;
    }

    public Animator onCreateAnimator(int transit, boolean enter, int nextAnim) {
        return null;
    }

    public void onCreate(Bundle savedInstanceState) {
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return null;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
    }

    public View getView() {
        return this.mContainerFragment.getView();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
    }

    public void onViewStateRestored(Bundle savedInstanceState) {
    }

    public void onStart() {
    }

    public void onResume() {
    }

    public void onSaveInstanceState(Bundle outState) {
    }

    public void onMultiWindowModeChanged(boolean isInMultiWindowMode, Configuration newConfig) {
    }

    public void onMultiWindowModeChanged(boolean isInMultiWindowMode) {
    }

    public void onPictureInPictureModeChanged(boolean isInPictureInPictureMode, Configuration newConfig) {
    }

    public void onPictureInPictureModeChanged(boolean isInPictureInPictureMode) {
    }

    public void onConfigurationChanged(Configuration newConfig) {
    }

    public void onPause() {
    }

    public void onStop() {
    }

    public void onLowMemory() {
    }

    public void onTrimMemory(int level) {
    }

    public void onDestroyView() {
    }

    public void onDestroy() {
    }

    public void onDetach() {
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
    }

    public void onPrepareOptionsMenu(Menu menu) {
    }

    public void onDestroyOptionsMenu() {
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        return false;
    }

    public void onOptionsMenuClosed(Menu menu) {
    }

    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
    }

    public void registerForContextMenu(View view) {
    }

    public void unregisterForContextMenu(View view) {
    }

    public boolean onContextItemSelected(MenuItem item) {
        return false;
    }

    public void setEnterSharedElementCallback(SharedElementCallback callback) {
    }

    public void setExitSharedElementCallback(SharedElementCallback callback) {
    }

    public void setEnterTransition(Transition transition) {
    }

    public Transition getEnterTransition() {
        return null;
    }

    public void setReturnTransition(Transition transition) {
    }

    public Transition getReturnTransition() {
        return null;
    }

    public void setExitTransition(Transition transition) {
    }

    public Transition getExitTransition() {
        return null;
    }

    public void setReenterTransition(Transition transition) {
    }

    public Transition getReenterTransition() {
        return null;
    }

    public void setSharedElementEnterTransition(Transition transition) {
    }

    public Transition getSharedElementEnterTransition() {
        return null;
    }

    public void setSharedElementReturnTransition(Transition transition) {
    }

    public Transition getSharedElementReturnTransition() {
        return null;
    }

    public void setAllowEnterTransitionOverlap(boolean allow) {
    }

    public boolean getAllowEnterTransitionOverlap() {
        return false;
    }

    public void setAllowReturnTransitionOverlap(boolean allow) {
    }

    public boolean getAllowReturnTransitionOverlap() {
        return false;
    }

    public void postponeEnterTransition() {
    }

    public void startPostponedEnterTransition() {
    }

    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
    }

    public final boolean isAdded() {
        return this.mContainerFragment.isAdded();
    }

    public final boolean isDetached() {
        return this.mContainerFragment.isDetached();
    }

    public final boolean isRemoving() {
        return this.mContainerFragment.isRemoving();
    }

    public final boolean isInLayout() {
        return this.mContainerFragment.isInLayout();
    }

    public final boolean isResumed() {
        return this.mContainerFragment.isResumed();
    }

    public final boolean isVisible() {
        return this.mContainerFragment.isVisible();
    }

    public final boolean isHidden() {
        return this.mContainerFragment.isHidden();
    }

    public final int getId() {
        return this.mContainerFragment.getId();
    }

    public final String getTag() {
        return this.mContainerFragment.getTag();
    }

    public final CharSequence getText(int resId) {
        return this.getResources().getText(resId);
    }

    public final String getString(int resId) {
        return this.getResources().getString(resId);
    }

    public final String getString(int resId, Object ... formatArgs) {
        return this.getResources().getString(resId, formatArgs);
    }

    public final void requestPermissions(String[] permissions, int requestCode) {
        this.mContainerFragment.requestPermissions(permissions, requestCode);
    }

    @SuppressLint(value={"NewApi"})
    public final ShadowFragment getParentFragment() {
        Fragment parentFragment = this.mContainerFragment.asFragment().getParentFragment();
        return ((IContainerFragment)parentFragment).getPluginFragment();
    }
}

