/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.core.runtime;

import android.app.Application;
import android.app.FragmentManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.tencent.shadow.core.runtime.PluginActivity;
import com.tencent.shadow.core.runtime.PluginFragmentManager;
import com.tencent.shadow.core.runtime.ShadowActivityLifecycleCallbacks;
import com.tencent.shadow.core.runtime.ShadowApplication;
import com.tencent.shadow.core.runtime.XmlPullParserUtil;
import com.tencent.shadow.core.runtime.container.GeneratedHostActivityDelegator;
import java.util.HashMap;
import java.util.Map;

public abstract class ShadowActivity
extends PluginActivity {
    private int mFragmentManagerHash;
    private PluginFragmentManager mPluginFragmentManager;
    private final Map<ShadowActivityLifecycleCallbacks, Application.ActivityLifecycleCallbacks> mActivityLifecycleCallbacksMap = new HashMap<ShadowActivityLifecycleCallbacks, Application.ActivityLifecycleCallbacks>();

    @Override
    public void setContentView(int layoutResID) {
        if ("merge".equals(XmlPullParserUtil.getLayoutStartTagName(this.getResources(), layoutResID))) {
            View decorView = this.hostActivityDelegator.getWindow().getDecorView();
            ViewGroup viewGroup = (ViewGroup)decorView.findViewById(0x1020002);
            LayoutInflater.from((Context)this).inflate(layoutResID, viewGroup);
        } else {
            View inflate = LayoutInflater.from((Context)this).inflate(layoutResID, null);
            this.hostActivityDelegator.setContentView(inflate);
        }
    }

    @Override
    public final ShadowApplication getApplication() {
        return this.mPluginApplication;
    }

    @Override
    public PluginFragmentManager getFragmentManager() {
        FragmentManager fragmentManager = this.hostActivityDelegator.getFragmentManager();
        int hash = System.identityHashCode(fragmentManager);
        if (hash != this.mFragmentManagerHash) {
            this.mFragmentManagerHash = hash;
            this.mPluginFragmentManager = new PluginFragmentManager(fragmentManager);
        }
        return this.mPluginFragmentManager;
    }

    @Override
    public final ShadowActivity getParent() {
        return null;
    }

    @Override
    public void overridePendingTransition(int enterAnim, int exitAnim) {
        if ((enterAnim & 0xFF000000) != 0x1000000) {
            enterAnim = 0;
        }
        if ((exitAnim & 0xFF000000) != 0x1000000) {
            exitAnim = 0;
        }
        this.hostActivityDelegator.overridePendingTransition(enterAnim, exitAnim);
    }

    @Override
    public void startActivityForResult(Intent intent, int requestCode) {
        this.startActivityForResult(intent, requestCode, null);
    }

    @Override
    public void startActivityForResult(Intent intent, int requestCode, Bundle options) {
        Intent pluginIntent = new Intent(intent);
        pluginIntent.setExtrasClassLoader(this.mPluginClassLoader);
        ComponentName callingActivity = new ComponentName(this.getPackageName(), ((Object)((Object)this)).getClass().getName());
        boolean success = this.mPluginComponentLauncher.startActivityForResult((GeneratedHostActivityDelegator)this.hostActivityDelegator, pluginIntent, requestCode, options, callingActivity);
        if (!success) {
            this.hostActivityDelegator.startActivityForResult(intent, requestCode, options);
        }
    }

    @Override
    public SharedPreferences getPreferences(int mode) {
        return super.getSharedPreferences(this.getLocalClassName(), mode);
    }

    @Override
    public String getLocalClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    public boolean shouldUpRecreateTask(Intent targetIntent) {
        Intent intent = this.mPluginComponentLauncher.convertPluginActivityIntent(targetIntent);
        return this.hostActivityDelegator.shouldUpRecreateTask(intent);
    }

    @Override
    public boolean navigateUpTo(Intent upIntent) {
        Intent intent = this.mPluginComponentLauncher.convertPluginActivityIntent(upIntent);
        return this.hostActivityDelegator.navigateUpTo(intent);
    }

    @Override
    public final <T extends View> T requireViewById(int id2) {
        Object view = this.findViewById(id2);
        if (view == null) {
            throw new IllegalArgumentException("ID does not reference a View inside this Activity");
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerActivityLifecycleCallbacks(ShadowActivityLifecycleCallbacks callback) {
        Map<ShadowActivityLifecycleCallbacks, Application.ActivityLifecycleCallbacks> map = this.mActivityLifecycleCallbacksMap;
        synchronized (map) {
            ShadowActivityLifecycleCallbacks.Wrapper wrapper = new ShadowActivityLifecycleCallbacks.Wrapper(callback, (Object)this);
            this.mActivityLifecycleCallbacksMap.put(callback, wrapper);
            this.hostActivityDelegator.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterActivityLifecycleCallbacks(ShadowActivityLifecycleCallbacks callback) {
        Map<ShadowActivityLifecycleCallbacks, Application.ActivityLifecycleCallbacks> map = this.mActivityLifecycleCallbacksMap;
        synchronized (map) {
            Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = this.mActivityLifecycleCallbacksMap.get(callback);
            if (activityLifecycleCallbacks != null) {
                this.hostActivityDelegator.unregisterActivityLifecycleCallbacks(activityLifecycleCallbacks);
                this.mActivityLifecycleCallbacksMap.remove(callback);
            }
        }
    }

    @Override
    public void startIntentSenderFromChild(ShadowActivity arg0, IntentSender arg1, int arg2, Intent arg3, int arg4, int arg5, int arg6) throws IntentSender.SendIntentException {
        throw new UnsupportedOperationException("Unsupported Yet");
    }

    @Override
    public void startIntentSenderFromChild(ShadowActivity arg0, IntentSender arg1, int arg2, Intent arg3, int arg4, int arg5, int arg6, Bundle arg7) throws IntentSender.SendIntentException {
        throw new UnsupportedOperationException("Unsupported Yet");
    }

    @Override
    public boolean navigateUpToFromChild(ShadowActivity arg0, Intent arg1) {
        throw new UnsupportedOperationException("Unsupported Yet");
    }

    @Override
    public void finishFromChild(ShadowActivity arg0) {
        throw new UnsupportedOperationException("Unsupported Yet");
    }

    @Override
    public void finishActivityFromChild(ShadowActivity arg0, int arg1) {
        throw new UnsupportedOperationException("Unsupported Yet");
    }

    public void setTheme(int resid) {
        this.hostActivityDelegator.setTheme(resid);
    }

    @Override
    public ComponentName getCallingActivity() {
        return this.mCallingActivity;
    }
}

