/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.core.runtime;

import android.annotation.TargetApi;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.view.View;
import com.tencent.shadow.core.runtime.PluginFragmentManager;
import com.tencent.shadow.core.runtime.ShadowFragment;

public class PluginFragmentTransaction {
    final FragmentTransaction mBase;
    final PluginFragmentManager mPluginFragmentManager;

    PluginFragmentTransaction(PluginFragmentManager pluginFragmentManager, FragmentTransaction mBase) {
        this.mPluginFragmentManager = pluginFragmentManager;
        this.mBase = mBase;
    }

    private Fragment getContainerFragment(ShadowFragment shadowFragment) {
        return shadowFragment.getContainerFragment().asFragment();
    }

    public PluginFragmentTransaction add(ShadowFragment fragment, String tag) {
        this.mBase.add(this.getContainerFragment(fragment), tag);
        return this;
    }

    public PluginFragmentTransaction add(int containerViewId, ShadowFragment fragment) {
        this.mBase.add(containerViewId, this.getContainerFragment(fragment));
        return this;
    }

    public PluginFragmentTransaction add(int containerViewId, ShadowFragment fragment, String tag) {
        this.mBase.add(containerViewId, this.getContainerFragment(fragment), tag);
        return this;
    }

    public PluginFragmentTransaction replace(int containerViewId, ShadowFragment fragment) {
        this.mBase.replace(containerViewId, this.getContainerFragment(fragment));
        return this;
    }

    public PluginFragmentTransaction replace(int containerViewId, ShadowFragment fragment, String tag) {
        this.mBase.replace(containerViewId, this.getContainerFragment(fragment), tag);
        return this;
    }

    public PluginFragmentTransaction remove(ShadowFragment fragment) {
        this.mBase.remove(this.getContainerFragment(fragment));
        return this;
    }

    public PluginFragmentTransaction hide(ShadowFragment fragment) {
        this.mBase.hide(this.getContainerFragment(fragment));
        return this;
    }

    public PluginFragmentTransaction show(ShadowFragment fragment) {
        this.mBase.show(this.getContainerFragment(fragment));
        return this;
    }

    public PluginFragmentTransaction detach(ShadowFragment fragment) {
        this.mBase.detach(this.getContainerFragment(fragment));
        return this;
    }

    public PluginFragmentTransaction attach(ShadowFragment fragment) {
        this.mBase.attach(this.getContainerFragment(fragment));
        return this;
    }

    @TargetApi(value=26)
    public PluginFragmentTransaction setPrimaryNavigationFragment(ShadowFragment fragment) {
        this.mBase.setPrimaryNavigationFragment(this.getContainerFragment(fragment));
        return this;
    }

    public boolean isEmpty() {
        return this.mBase.isEmpty();
    }

    public PluginFragmentTransaction setCustomAnimations(int enter, int exit) {
        this.mBase.setCustomAnimations(enter, exit);
        return this;
    }

    public PluginFragmentTransaction setCustomAnimations(int enter, int exit, int popEnter, int popExit) {
        this.mBase.setCustomAnimations(enter, exit, popEnter, popExit);
        return this;
    }

    public PluginFragmentTransaction setTransition(int transit) {
        this.mBase.setTransition(transit);
        return this;
    }

    @TargetApi(value=21)
    public PluginFragmentTransaction addSharedElement(View sharedElement, String name) {
        this.mBase.addSharedElement(sharedElement, name);
        return this;
    }

    public PluginFragmentTransaction setTransitionStyle(int styleRes) {
        this.mBase.setTransitionStyle(styleRes);
        return this;
    }

    public PluginFragmentTransaction addToBackStack(String name) {
        this.mBase.addToBackStack(name);
        return this;
    }

    public boolean isAddToBackStackAllowed() {
        return this.mBase.isAddToBackStackAllowed();
    }

    public PluginFragmentTransaction disallowAddToBackStack() {
        this.mBase.disallowAddToBackStack();
        return this;
    }

    public PluginFragmentTransaction setBreadCrumbTitle(int res) {
        this.mBase.setBreadCrumbTitle(res);
        return this;
    }

    public PluginFragmentTransaction setBreadCrumbTitle(CharSequence text) {
        this.mBase.setBreadCrumbTitle(text);
        return this;
    }

    public PluginFragmentTransaction setBreadCrumbShortTitle(int res) {
        this.mBase.setBreadCrumbShortTitle(res);
        return this;
    }

    public PluginFragmentTransaction setBreadCrumbShortTitle(CharSequence text) {
        this.mBase.setBreadCrumbShortTitle(text);
        return this;
    }

    @TargetApi(value=26)
    public PluginFragmentTransaction setReorderingAllowed(boolean reorderingAllowed) {
        this.mBase.setReorderingAllowed(reorderingAllowed);
        return this;
    }

    @TargetApi(value=26)
    public PluginFragmentTransaction runOnCommit(Runnable runnable) {
        this.mBase.runOnCommit(runnable);
        return this;
    }

    public int commit() {
        return this.mBase.commit();
    }

    public int commitAllowingStateLoss() {
        return this.mBase.commitAllowingStateLoss();
    }

    @TargetApi(value=24)
    public void commitNow() {
        this.mBase.commitNow();
    }

    @TargetApi(value=24)
    public void commitNowAllowingStateLoss() {
        this.mBase.commitNowAllowingStateLoss();
    }
}

