/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.core.runtime;

import android.animation.Animator;
import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.Fragment;
import android.app.LoaderManager;
import android.app.SharedElementCallback;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.transition.Transition;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.tencent.shadow.core.runtime.IContainerDialogFragment;
import com.tencent.shadow.core.runtime.PluginActivity;
import com.tencent.shadow.core.runtime.ShadowActivity;
import com.tencent.shadow.core.runtime.ShadowDialogFragment;
import com.tencent.shadow.core.runtime.ShadowFragment;
import com.tencent.shadow.core.runtime.container.PluginContainerActivity;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class ContainerDialogFragment
extends DialogFragment
implements IContainerDialogFragment {
    private static Map<String, Constructor<?>> constructorMap = new HashMap();
    private boolean init = false;
    private OnInflateParams mOnInflateParams;
    private boolean mDestroyed;
    private ShadowDialogFragment mPluginFragment;
    private boolean mIsAppCreateFragment = false;

    @Override
    public Fragment asFragment() {
        return this;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        return this.mPluginFragment.onCreateDialog(savedInstanceState);
    }

    private static ShadowDialogFragment instantiatePluginFragment(ContainerDialogFragment containerFragment, Context context) {
        String pluginFragmentClassName = containerFragment.getClass().getName() + "_";
        Constructor<?> constructor = constructorMap.get(pluginFragmentClassName);
        if (constructor == null) {
            PluginContainerActivity containerActivity = (PluginContainerActivity)context;
            PluginActivity pluginActivity = PluginActivity.get(containerActivity);
            ClassLoader pluginClassLoader = pluginActivity.getClassLoader();
            try {
                Class<?> aClass = pluginClassLoader.loadClass(pluginFragmentClassName);
                constructor = aClass.getConstructor(new Class[0]);
                constructorMap.put(pluginFragmentClassName, constructor);
            }
            catch (Exception e) {
                throw new Fragment.InstantiationException("\u65e0\u6cd5\u6784\u9020" + pluginFragmentClassName, e);
            }
        }
        try {
            return (ShadowDialogFragment)ShadowDialogFragment.class.cast(constructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new Fragment.InstantiationException("\u65e0\u6cd5\u6784\u9020" + pluginFragmentClassName, e);
        }
    }

    @Override
    public ShadowFragment getPluginFragment() {
        return this.mPluginFragment;
    }

    @Override
    public void bindPluginFragment(ShadowFragment pluginFragment) {
        this.init = true;
        this.mIsAppCreateFragment = true;
        this.mPluginFragment = (ShadowDialogFragment)pluginFragment;
    }

    @Override
    public void unbindPluginFragment() {
        this.init = false;
        this.mPluginFragment = null;
    }

    private void initPluginFragment(Context context) {
        if (this.init) {
            return;
        }
        this.init = true;
        this.onBindPluginFragment(context);
        if (this.mOnInflateParams != null) {
            this.mPluginFragment.onInflate(this.mOnInflateParams.attrs, this.mOnInflateParams.savedInstanceState);
            this.mOnInflateParams = null;
        }
    }

    private void onBindPluginFragment(Context context) {
        this.mPluginFragment = ContainerDialogFragment.instantiatePluginFragment(this, context);
        this.mPluginFragment.setContainerFragment(this);
    }

    private void onUnbindPluginFragment() {
        this.mPluginFragment.setContainerFragment(null);
        this.mPluginFragment = null;
    }

    public void onAttach(Context context) {
        this.initPluginFragment(context);
        super.onAttach(context);
        if (context instanceof PluginContainerActivity) {
            PluginActivity pluginActivity = PluginActivity.get((PluginContainerActivity)context);
            this.mPluginFragment.onAttach((Context)pluginActivity);
        }
    }

    @Deprecated
    public void onAttach(Activity activity) {
        this.initPluginFragment((Context)activity);
        super.onAttach(activity);
        if (activity instanceof PluginContainerActivity) {
            PluginActivity pluginActivity = PluginActivity.get((PluginContainerActivity)activity);
            this.mPluginFragment.onAttach((ShadowActivity)pluginActivity);
        }
    }

    public String toString() {
        return this.mPluginFragment.toString();
    }

    @Override
    public void setArguments(Bundle args) {
        if (!this.mIsAppCreateFragment) {
            this.mPluginFragment.setArguments(args);
        } else {
            super.setArguments(args);
        }
    }

    public void setInitialSavedState(Fragment.SavedState state) {
        this.mPluginFragment.setInitialSavedState(state);
    }

    public void setTargetFragment(Fragment fragment, int requestCode) {
        this.mPluginFragment.setTargetFragment(fragment, requestCode);
    }

    @Override
    public Context getContext() {
        return this.mPluginFragment.getContext();
    }

    public void onHiddenChanged(boolean hidden) {
        this.mPluginFragment.onHiddenChanged(hidden);
    }

    public void setRetainInstance(boolean retain) {
        this.mPluginFragment.setRetainInstance(retain);
    }

    public void setHasOptionsMenu(boolean hasMenu) {
        this.mPluginFragment.setHasOptionsMenu(hasMenu);
    }

    public void setMenuVisibility(boolean menuVisible) {
        this.mPluginFragment.setMenuVisibility(menuVisible);
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        this.mPluginFragment.setUserVisibleHint(isVisibleToUser);
    }

    public LoaderManager getLoaderManager() {
        return this.mPluginFragment.getLoaderManager();
    }

    public void startActivity(Intent intent) {
        this.mPluginFragment.startActivity(intent);
    }

    public void startActivity(Intent intent, Bundle options) {
        this.mPluginFragment.startActivity(intent, options);
    }

    public void startActivityForResult(Intent intent, int requestCode) {
        this.mPluginFragment.startActivityForResult(intent, requestCode);
    }

    public void startActivityForResult(Intent intent, int requestCode, Bundle options) {
        this.mPluginFragment.startActivityForResult(intent, requestCode, options);
    }

    public void startIntentSenderForResult(IntentSender intent, int requestCode, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) throws IntentSender.SendIntentException {
        this.mPluginFragment.startIntentSenderForResult(intent, requestCode, fillInIntent, flagsMask, flagsValues, extraFlags, options);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.mPluginFragment.onActivityResult(requestCode, resultCode, data);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        this.mPluginFragment.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public boolean shouldShowRequestPermissionRationale(String permission) {
        return this.mPluginFragment.shouldShowRequestPermissionRationale(permission);
    }

    @Deprecated
    public void onInflate(AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(attrs, savedInstanceState);
        this.mOnInflateParams = new OnInflateParams(attrs, savedInstanceState);
        if (this.mPluginFragment != null) {
            this.mPluginFragment.onInflate(attrs, savedInstanceState);
        }
    }

    public void onInflate(Context context, AttributeSet attrs, Bundle savedInstanceState) {
        this.initPluginFragment(context);
        super.onInflate(context, attrs, savedInstanceState);
        this.mPluginFragment.onInflate(context, attrs, savedInstanceState);
    }

    @Deprecated
    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        this.mPluginFragment.onInflate(activity, attrs, savedInstanceState);
    }

    public void onAttachFragment(Fragment childFragment) {
        this.mPluginFragment.onAttachFragment(childFragment);
    }

    public Animator onCreateAnimator(int transit, boolean enter, int nextAnim) {
        return this.mPluginFragment.onCreateAnimator(transit, enter, nextAnim);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mPluginFragment.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.mPluginFragment.onCreateView(inflater, container, savedInstanceState);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        this.mPluginFragment.onViewCreated(view, savedInstanceState);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mPluginFragment.onActivityCreated(savedInstanceState);
    }

    public void onViewStateRestored(Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        this.mPluginFragment.onViewStateRestored(savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.mPluginFragment.onStart();
    }

    public void onResume() {
        super.onResume();
        this.mPluginFragment.onResume();
    }

    public void onSaveInstanceState(Bundle outState) {
        this.mPluginFragment.onSaveInstanceState(outState);
    }

    public void onMultiWindowModeChanged(boolean isInMultiWindowMode, Configuration newConfig) {
        this.mPluginFragment.onMultiWindowModeChanged(isInMultiWindowMode, newConfig);
    }

    @Deprecated
    public void onMultiWindowModeChanged(boolean isInMultiWindowMode) {
        this.mPluginFragment.onMultiWindowModeChanged(isInMultiWindowMode);
    }

    public void onPictureInPictureModeChanged(boolean isInPictureInPictureMode, Configuration newConfig) {
        this.mPluginFragment.onPictureInPictureModeChanged(isInPictureInPictureMode, newConfig);
    }

    @Deprecated
    public void onPictureInPictureModeChanged(boolean isInPictureInPictureMode) {
        this.mPluginFragment.onPictureInPictureModeChanged(isInPictureInPictureMode);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mPluginFragment.onConfigurationChanged(newConfig);
    }

    public void onPause() {
        super.onPause();
        this.mPluginFragment.onPause();
    }

    public void onStop() {
        super.onStop();
        this.mPluginFragment.onStop();
    }

    public void onLowMemory() {
        super.onLowMemory();
        this.mPluginFragment.onLowMemory();
    }

    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        this.mPluginFragment.onTrimMemory(level);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mPluginFragment.onDestroyView();
    }

    public void onDestroy() {
        super.onDestroy();
        this.mPluginFragment.onDestroy();
        this.mDestroyed = true;
    }

    public void onDetach() {
        super.onDetach();
        this.mPluginFragment.onDetach();
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        this.mPluginFragment.onCreateOptionsMenu(menu, inflater);
    }

    public void onPrepareOptionsMenu(Menu menu) {
        this.mPluginFragment.onPrepareOptionsMenu(menu);
    }

    public void onDestroyOptionsMenu() {
        this.mPluginFragment.onDestroyOptionsMenu();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        return this.mPluginFragment.onOptionsItemSelected(item);
    }

    public void onOptionsMenuClosed(Menu menu) {
        this.mPluginFragment.onOptionsMenuClosed(menu);
    }

    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        this.mPluginFragment.onCreateContextMenu(menu, v, menuInfo);
    }

    public void registerForContextMenu(View view) {
        this.mPluginFragment.registerForContextMenu(view);
    }

    public void unregisterForContextMenu(View view) {
        this.mPluginFragment.unregisterForContextMenu(view);
    }

    public boolean onContextItemSelected(MenuItem item) {
        return this.mPluginFragment.onContextItemSelected(item);
    }

    public void setEnterSharedElementCallback(SharedElementCallback callback) {
        this.mPluginFragment.setEnterSharedElementCallback(callback);
    }

    public void setExitSharedElementCallback(SharedElementCallback callback) {
        this.mPluginFragment.setExitSharedElementCallback(callback);
    }

    public void setEnterTransition(Transition transition) {
        this.mPluginFragment.setEnterTransition(transition);
    }

    public Transition getEnterTransition() {
        return this.mPluginFragment.getEnterTransition();
    }

    public void setReturnTransition(Transition transition) {
        this.mPluginFragment.setReturnTransition(transition);
    }

    public Transition getReturnTransition() {
        return this.mPluginFragment.getReturnTransition();
    }

    public void setExitTransition(Transition transition) {
        this.mPluginFragment.setExitTransition(transition);
    }

    public Transition getExitTransition() {
        return this.mPluginFragment.getExitTransition();
    }

    public void setReenterTransition(Transition transition) {
        this.mPluginFragment.setReenterTransition(transition);
    }

    public Transition getReenterTransition() {
        return this.mPluginFragment.getReenterTransition();
    }

    public void setSharedElementEnterTransition(Transition transition) {
        this.mPluginFragment.setSharedElementEnterTransition(transition);
    }

    public Transition getSharedElementEnterTransition() {
        return this.mPluginFragment.getSharedElementEnterTransition();
    }

    public void setSharedElementReturnTransition(Transition transition) {
        this.mPluginFragment.setSharedElementReturnTransition(transition);
    }

    public Transition getSharedElementReturnTransition() {
        return this.mPluginFragment.getSharedElementReturnTransition();
    }

    public void setAllowEnterTransitionOverlap(boolean allow) {
        this.mPluginFragment.setAllowEnterTransitionOverlap(allow);
    }

    public boolean getAllowEnterTransitionOverlap() {
        return this.mPluginFragment.getAllowEnterTransitionOverlap();
    }

    public void setAllowReturnTransitionOverlap(boolean allow) {
        this.mPluginFragment.setAllowReturnTransitionOverlap(allow);
    }

    public boolean getAllowReturnTransitionOverlap() {
        return this.mPluginFragment.getAllowReturnTransitionOverlap();
    }

    public void postponeEnterTransition() {
        this.mPluginFragment.postponeEnterTransition();
    }

    public void startPostponedEnterTransition() {
        this.mPluginFragment.startPostponedEnterTransition();
    }

    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        this.mPluginFragment.dump(prefix, fd, writer, args);
    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        this.mPluginFragment.onDismiss(dialog);
    }

    public void onCancel(DialogInterface dialog) {
        this.mPluginFragment.onCancel(dialog);
    }

    @Override
    public void superSetUserVisibleHint(boolean isVisibleToUser) {
        if (Build.VERSION.SDK_INT >= 15) {
            super.setUserVisibleHint(isVisibleToUser);
        }
    }

    @Override
    public void superSetRetainInstance(boolean retain) {
        super.setRetainInstance(retain);
    }

    @Override
    public void superSetHasOptionsMenu(boolean hasMenu) {
        super.setHasOptionsMenu(hasMenu);
    }

    @Override
    public void superSetMenuVisibility(boolean menuVisible) {
        super.setMenuVisibility(menuVisible);
    }

    @Override
    public void superOnHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
    }

    @Override
    public void superOnDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
    }

    private static class OnInflateParams {
        final AttributeSet attrs;
        final Bundle savedInstanceState;

        private OnInflateParams(AttributeSet attrs, Bundle savedInstanceState) {
            this.attrs = attrs;
            this.savedInstanceState = savedInstanceState;
        }
    }
}

