/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.core.loader;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import com.tencent.shadow.core.common.InstalledApk;
import com.tencent.shadow.core.common.Logger;
import com.tencent.shadow.core.common.LoggerFactory;
import com.tencent.shadow.core.load_parameters.LoadParameters;
import com.tencent.shadow.core.loader.ShadowPluginLoader;
import com.tencent.shadow.core.loader.blocs.LoadPluginBloc;
import com.tencent.shadow.core.loader.delegates.DI;
import com.tencent.shadow.core.loader.delegates.ShadowActivityDelegate;
import com.tencent.shadow.core.loader.delegates.ShadowContentProviderDelegate;
import com.tencent.shadow.core.loader.delegates.ShadowDelegate;
import com.tencent.shadow.core.loader.infos.PluginParts;
import com.tencent.shadow.core.loader.managers.ComponentManager;
import com.tencent.shadow.core.loader.managers.PluginContentProviderManager;
import com.tencent.shadow.core.loader.managers.PluginServiceManager;
import com.tencent.shadow.core.runtime.ShadowApplication;
import com.tencent.shadow.core.runtime.UriConverter;
import com.tencent.shadow.core.runtime.container.ContentProviderDelegateProvider;
import com.tencent.shadow.core.runtime.container.DelegateProvider;
import com.tencent.shadow.core.runtime.container.HostActivityDelegate;
import com.tencent.shadow.core.runtime.container.HostActivityDelegator;
import com.tencent.shadow.core.runtime.container.HostContentProviderDelegate;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 D2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001DB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001d0(H\u0002\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\bJ\"\u0010-\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020 0\u001fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020 `!J\b\u0010.\u001a\u00020\fH&J\u0018\u0010/\u001a\u0002002\u000e\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020302H\u0016J\b\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u0004\u0018\u00010 2\u0006\u0010,\u001a\u00020\bJ\u0006\u00107\u001a\u00020#J\u0018\u00108\u001a\u00020+2\u0006\u00109\u001a\u00020:2\u0006\u0010,\u001a\u00020\bH\u0016J\b\u0010;\u001a\u00020<H\u0002J\u0014\u0010=\u001a\u0006\u0012\u0002\b\u00030>2\u0006\u0010?\u001a\u00020@H\u0016J\u0006\u0010A\u001a\u00020+J\n\u0010B\u001a\u00020C*\u00020@R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001e\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020 0\u001fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020 `!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/tencent/shadow/core/loader/ShadowPluginLoader;", "Lcom/tencent/shadow/core/runtime/container/DelegateProvider;", "Lcom/tencent/shadow/core/loader/delegates/DI;", "Lcom/tencent/shadow/core/runtime/container/ContentProviderDelegateProvider;", "hostAppContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "delegateProviderKey", "", "getDelegateProviderKey", "()Ljava/lang/String;", "mComponentManager", "Lcom/tencent/shadow/core/loader/managers/ComponentManager;", "getMComponentManager", "()Lcom/tencent/shadow/core/loader/managers/ComponentManager;", "setMComponentManager", "(Lcom/tencent/shadow/core/loader/managers/ComponentManager;)V", "mExecutorService", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "getMExecutorService", "()Ljava/util/concurrent/ExecutorService;", "mHostAppContext", "mLock", "Ljava/util/concurrent/locks/ReentrantLock;", "mPluginContentProviderManager", "Lcom/tencent/shadow/core/loader/managers/PluginContentProviderManager;", "mPluginPackageInfoSet", "", "Landroid/content/pm/PackageInfo;", "mPluginPartsMap", "Ljava/util/HashMap;", "Lcom/tencent/shadow/core/loader/infos/PluginParts;", "Lkotlin/collections/HashMap;", "mPluginServiceManager", "Lcom/tencent/shadow/core/loader/managers/PluginServiceManager;", "mPluginServiceManagerLock", "mUiHandler", "Landroid/os/Handler;", "allPluginPackageInfo", "", "()[Landroid/content/pm/PackageInfo;", "callApplicationOnCreate", "", "partKey", "getAllPluginPart", "getComponentManager", "getHostActivityDelegate", "Lcom/tencent/shadow/core/runtime/container/HostActivityDelegate;", "aClass", "Ljava/lang/Class;", "Lcom/tencent/shadow/core/runtime/container/HostActivityDelegator;", "getHostContentProviderDelegate", "Lcom/tencent/shadow/core/runtime/container/HostContentProviderDelegate;", "getPluginParts", "getPluginServiceManager", "inject", "delegate", "Lcom/tencent/shadow/core/loader/delegates/ShadowDelegate;", "isUiThread", "", "loadPlugin", "Ljava/util/concurrent/Future;", "installedApk", "Lcom/tencent/shadow/core/common/InstalledApk;", "onCreate", "getLoadParameters", "Lcom/tencent/shadow/core/load_parameters/LoadParameters;", "Companion", "loader_release"})
public abstract class ShadowPluginLoader
implements DI,
ContentProviderDelegateProvider,
DelegateProvider {
    private final ExecutorService mExecutorService;
    @NotNull
    private final String delegateProviderKey = "DEFAULT_KEY";
    private final ReentrantLock mLock;
    private final HashMap<String, PluginParts> mPluginPartsMap;
    @NotNull
    public ComponentManager mComponentManager;
    private final Set<PackageInfo> mPluginPackageInfoSet;
    private PluginServiceManager mPluginServiceManager;
    private final PluginContentProviderManager mPluginContentProviderManager;
    private final ReentrantLock mPluginServiceManagerLock;
    private final Context mHostAppContext;
    private final Handler mUiHandler;
    private static final Logger mLogger;
    public static final Companion Companion;

    protected final ExecutorService getMExecutorService() {
        return this.mExecutorService;
    }

    @NotNull
    public String getDelegateProviderKey() {
        return this.delegateProviderKey;
    }

    @NotNull
    public final ComponentManager getMComponentManager() {
        ComponentManager componentManager = this.mComponentManager;
        if (componentManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mComponentManager");
        }
        return componentManager;
    }

    public final void setMComponentManager(@NotNull ComponentManager componentManager) {
        Intrinsics.checkParameterIsNotNull((Object)componentManager, (String)"<set-?>");
        this.mComponentManager = componentManager;
    }

    @NotNull
    public abstract ComponentManager getComponentManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final PluginServiceManager getPluginServiceManager() {
        Lock lock = this.mPluginServiceManagerLock;
        lock.lock();
        try {
            PluginServiceManager pluginServiceManager = this.mPluginServiceManager;
            if (pluginServiceManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPluginServiceManager");
            }
            PluginServiceManager pluginServiceManager2 = pluginServiceManager;
            return pluginServiceManager2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final PluginParts getPluginParts(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"partKey");
        Lock lock = this.mLock;
        lock.lock();
        try {
            PluginParts pluginParts = this.mPluginPartsMap.get(string);
            return pluginParts;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final HashMap<String, PluginParts> getAllPluginPart() {
        Lock lock = this.mLock;
        lock.lock();
        try {
            HashMap<String, PluginParts> hashMap = this.mPluginPartsMap;
            return hashMap;
        }
        finally {
            lock.unlock();
        }
    }

    public final void onCreate() {
        ComponentManager componentManager = this.mComponentManager = this.getComponentManager();
        if (componentManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mComponentManager");
        }
        componentManager.setPluginContentProviderManager(this.mPluginContentProviderManager);
    }

    public final void callApplicationOnCreate(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"partKey");
        Function0<Unit> function0 = new Function0<Unit>(this, string){
            final /* synthetic */ ShadowPluginLoader this$0;
            final /* synthetic */ String $partKey;

            public final void invoke() {
                block2: {
                    PluginParts pluginParts;
                    PluginParts pluginParts2;
                    PluginParts pluginParts3 = pluginParts2 = this.this$0.getPluginParts(this.$partKey);
                    if (pluginParts3 == null) break block2;
                    PluginParts pluginParts4 = pluginParts = pluginParts3;
                    ShadowApplication shadowApplication = pluginParts2.getApplication();
                    shadowApplication.attachBaseContext(ShadowPluginLoader.access$getMHostAppContext$p(this.this$0));
                    try {
                        ShadowPluginLoader.access$getMPluginContentProviderManager$p(this.this$0).createContentProviderAndCallOnCreate((Context)shadowApplication, this.$partKey, pluginParts2);
                    }
                    catch (Exception exception) {
                        ShadowPluginLoader.access$getMLogger$cp().error("createContentProviderAndCallOnCreate", (Throwable)exception);
                    }
                    shadowApplication.onCreate();
                }
            }
            {
                this.this$0 = shadowPluginLoader;
                this.$partKey = string;
                super(0);
            }
        };
        if (this.isUiThread()) {
            function0.invoke();
        } else {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.mUiHandler.post(new Runnable(function0, countDownLatch){
                final /* synthetic */ callApplicationOnCreate.1 $realAction$1;
                final /* synthetic */ CountDownLatch $waitUiLock;

                public final void run() {
                    this.$realAction$1.invoke();
                    this.$waitUiLock.countDown();
                }
                {
                    this.$realAction$1 = var1_1;
                    this.$waitUiLock = countDownLatch;
                }
            });
            countDownLatch.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Future<?> loadPlugin(@NotNull InstalledApk installedApk) {
        Intrinsics.checkParameterIsNotNull((Object)installedApk, (String)"installedApk");
        LoadParameters loadParameters = this.getLoadParameters(installedApk);
        Logger logger = mLogger;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"mLogger");
        if (logger.isInfoEnabled()) {
            mLogger.info("start loadPlugin");
        }
        Lock lock = this.mPluginServiceManagerLock;
        lock.lock();
        try {
            if (this.mPluginServiceManager == null) {
                this.mPluginServiceManager = new PluginServiceManager(this, this.mHostAppContext);
            }
            ComponentManager componentManager = this.mComponentManager;
            if (componentManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mComponentManager");
            }
            PluginServiceManager pluginServiceManager = this.mPluginServiceManager;
            if (pluginServiceManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mPluginServiceManager");
            }
            componentManager.setPluginServiceManager(pluginServiceManager);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        ExecutorService executorService = this.mExecutorService;
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"mExecutorService");
        Function0 function0 = (Function0)new Function0<PackageInfo[]>(this){

            @NotNull
            public final PackageInfo[] invoke() {
                return ShadowPluginLoader.access$allPluginPackageInfo((ShadowPluginLoader)this.receiver);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ShadowPluginLoader.class);
            }

            public final String getName() {
                return "allPluginPackageInfo";
            }

            public final String getSignature() {
                return "allPluginPackageInfo()[Landroid/content/pm/PackageInfo;";
            }
        };
        ComponentManager componentManager = this.mComponentManager;
        if (componentManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mComponentManager");
        }
        return LoadPluginBloc.INSTANCE.loadPlugin(executorService, this.mPluginPackageInfoSet, (Function0<PackageInfo[]>)function0, componentManager, this.mLock, (Map<String, PluginParts>)this.mPluginPartsMap, this.mHostAppContext, installedApk, loadParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PackageInfo[] allPluginPackageInfo() {
        Lock lock = this.mLock;
        lock.lock();
        try {
            Collection collection;
            Collection collection2 = collection = (Collection)this.mPluginPackageInfoSet;
            if (collection2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection collection3 = collection2;
            PackageInfo[] packageInfoArray = collection3.toArray(new PackageInfo[0]);
            if (packageInfoArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            PackageInfo[] packageInfoArray2 = packageInfoArray;
            return packageInfoArray2;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public HostActivityDelegate getHostActivityDelegate(@NotNull Class<? extends HostActivityDelegator> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"aClass");
        return new ShadowActivityDelegate(this);
    }

    @NotNull
    public HostContentProviderDelegate getHostContentProviderDelegate() {
        return new ShadowContentProviderDelegate(this.mPluginContentProviderManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inject(@NotNull ShadowDelegate shadowDelegate, @NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)shadowDelegate, (String)"delegate");
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"partKey");
        Lock lock = this.mLock;
        lock.lock();
        try {
            PluginParts pluginParts = this.mPluginPartsMap.get(string);
            if (pluginParts == null) {
                throw (Throwable)new IllegalStateException("partKey==" + string + "\u5728map\u4e2d\u627e\u4e0d\u5230\u3002\u6b64\u65f6map\uff1a" + this.mPluginPartsMap);
            }
            shadowDelegate.inject(pluginParts.getAppComponentFactory());
            shadowDelegate.inject(pluginParts.getApplication());
            shadowDelegate.inject(pluginParts.getClassLoader());
            shadowDelegate.inject(pluginParts.getResources());
            ComponentManager componentManager = this.mComponentManager;
            if (componentManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mComponentManager");
            }
            shadowDelegate.inject(componentManager);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public final LoadParameters getLoadParameters(@NotNull InstalledApk installedApk) {
        Intrinsics.checkParameterIsNotNull((Object)installedApk, (String)"$receiver");
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(installedApk.parcelExtras, 0, installedApk.parcelExtras.length);
        parcel.setDataPosition(0);
        LoadParameters loadParameters = new LoadParameters(parcel);
        parcel.recycle();
        return loadParameters;
    }

    private final boolean isUiThread() {
        return Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper());
    }

    public ShadowPluginLoader(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"hostAppContext");
        this.mExecutorService = Executors.newCachedThreadPool();
        this.delegateProviderKey = "DEFAULT_KEY";
        this.mLock = new ReentrantLock();
        ShadowPluginLoader shadowPluginLoader = this;
        Cloneable cloneable = new HashMap();
        shadowPluginLoader.mPluginPartsMap = cloneable;
        shadowPluginLoader = this;
        cloneable = new HashSet();
        shadowPluginLoader.mPluginPackageInfoSet = (Set)((Object)cloneable);
        this.mPluginContentProviderManager = new PluginContentProviderManager();
        this.mPluginServiceManagerLock = new ReentrantLock();
        this.mHostAppContext = context;
        this.mUiHandler = new Handler(Looper.getMainLooper());
        UriConverter.setUriParseDelegate((UriConverter.UriParseDelegate)this.mPluginContentProviderManager);
    }

    static {
        Companion = new Companion(null);
        mLogger = LoggerFactory.getLogger(ShadowPluginLoader.class);
    }

    @NotNull
    public static final /* synthetic */ Context access$getMHostAppContext$p(ShadowPluginLoader shadowPluginLoader) {
        return shadowPluginLoader.mHostAppContext;
    }

    @NotNull
    public static final /* synthetic */ PluginContentProviderManager access$getMPluginContentProviderManager$p(ShadowPluginLoader shadowPluginLoader) {
        return shadowPluginLoader.mPluginContentProviderManager;
    }

    public static final /* synthetic */ Logger access$getMLogger$cp() {
        return mLogger;
    }

    @NotNull
    public static final /* synthetic */ PluginServiceManager access$getMPluginServiceManager$p(ShadowPluginLoader shadowPluginLoader) {
        PluginServiceManager pluginServiceManager = shadowPluginLoader.mPluginServiceManager;
        if (pluginServiceManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPluginServiceManager");
        }
        return pluginServiceManager;
    }

    public static final /* synthetic */ void access$setMPluginServiceManager$p(ShadowPluginLoader shadowPluginLoader, @NotNull PluginServiceManager pluginServiceManager) {
        shadowPluginLoader.mPluginServiceManager = pluginServiceManager;
    }

    @NotNull
    public static final /* synthetic */ PluginServiceManager access$getMPluginServiceManager$li(ShadowPluginLoader shadowPluginLoader) {
        return shadowPluginLoader.mPluginServiceManager;
    }

    public static final /* synthetic */ void access$setMPluginServiceManager$li(ShadowPluginLoader shadowPluginLoader, @NotNull PluginServiceManager pluginServiceManager) {
        shadowPluginLoader.mPluginServiceManager = pluginServiceManager;
    }

    @NotNull
    public static final /* synthetic */ PackageInfo[] access$allPluginPackageInfo(ShadowPluginLoader shadowPluginLoader) {
        return shadowPluginLoader.allPluginPackageInfo();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/tencent/shadow/core/loader/ShadowPluginLoader$Companion;", "", "()V", "mLogger", "Lcom/tencent/shadow/core/common/Logger;", "kotlin.jvm.PlatformType", "loader_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

