/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.shadow.core.runtime.container;

import android.app.Activity;
import android.content.res.Resources;
import android.os.Bundle;
import android.util.Log;
import android.view.Window;
import com.tencent.shadow.core.runtime.container.DelegateProvider;
import com.tencent.shadow.core.runtime.container.DelegateProviderHolder;
import com.tencent.shadow.core.runtime.container.GeneratedPluginContainerActivity;
import com.tencent.shadow.core.runtime.container.HostActivity;
import com.tencent.shadow.core.runtime.container.HostActivityDelegate;
import com.tencent.shadow.core.runtime.container.HostActivityDelegator;

public class PluginContainerActivity
extends GeneratedPluginContainerActivity
implements HostActivity,
HostActivityDelegator {
    private static final String TAG = "PluginContainerActivity";
    HostActivityDelegate hostActivityDelegate;
    private boolean isBeforeOnCreate = true;
    private Resources.Theme mHostTheme;

    public PluginContainerActivity() {
        HostActivityDelegate delegate;
        DelegateProvider delegateProvider = DelegateProviderHolder.getDelegateProvider(this.getDelegateProviderKey());
        if (delegateProvider != null) {
            delegate = delegateProvider.getHostActivityDelegate(this.getClass());
            delegate.setDelegator(this);
        } else {
            Log.e((String)TAG, (String)"PluginContainerActivity: DelegateProviderHolder\u6ca1\u6709\u521d\u59cb\u5316");
            delegate = null;
        }
        ((GeneratedPluginContainerActivity)this).hostActivityDelegate = delegate;
        this.hostActivityDelegate = delegate;
    }

    protected String getDelegateProviderKey() {
        return "DEFAULT_KEY";
    }

    public final Object getPluginActivity() {
        if (this.hostActivityDelegate != null) {
            return this.hostActivityDelegate.getPluginActivity();
        }
        return null;
    }

    @Override
    protected final void onCreate(Bundle savedInstanceState) {
        this.isBeforeOnCreate = false;
        this.mHostTheme = null;
        boolean illegalIntent = this.isIllegalIntent(savedInstanceState);
        if (illegalIntent) {
            this.hostActivityDelegate = null;
            Log.e((String)TAG, (String)("illegalIntent savedInstanceState==" + savedInstanceState + " getIntent().getExtras()==" + this.getIntent().getExtras()));
        }
        if (this.hostActivityDelegate != null) {
            this.hostActivityDelegate.onCreate(savedInstanceState);
        } else {
            super.onCreate(null);
            Log.e((String)TAG, (String)"onCreate: hostActivityDelegate==null finish activity");
            this.finish();
            System.exit(0);
        }
    }

    private boolean isIllegalIntent(Bundle savedInstanceState) {
        Bundle extras = this.getIntent().getExtras();
        if (extras == null && savedInstanceState == null) {
            return true;
        }
        Bundle bundle = savedInstanceState == null ? extras : savedInstanceState;
        try {
            String loaderVersion = bundle.getString("LOADER_VERSION");
            long processVersion = bundle.getLong("PROCESS_ID_KEY");
            return !"2.3.9".equals(loaderVersion) || processVersion != DelegateProviderHolder.sCustomPid;
        }
        catch (Throwable ignored) {
            return true;
        }
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        if (this.hostActivityDelegate != null) {
            this.hostActivityDelegate.onSaveInstanceState(outState);
        } else {
            super.onSaveInstanceState(outState);
        }
        outState.putString("LOADER_VERSION", "2.3.9");
        outState.putLong("PROCESS_ID_KEY", DelegateProviderHolder.sCustomPid);
    }

    @Override
    public HostActivity getHostActivity() {
        return this;
    }

    @Override
    public Activity getImplementActivity() {
        return this;
    }

    @Override
    public Window getImplementWindow() {
        return this.getWindow();
    }

    @Override
    public Resources.Theme getTheme() {
        if (this.isBeforeOnCreate) {
            if (this.mHostTheme == null) {
                this.mHostTheme = super.getResources().newTheme();
            }
            return this.mHostTheme;
        }
        return super.getTheme();
    }

    @Override
    public void setTheme(int resid) {
        if (!this.isBeforeOnCreate) {
            super.setTheme(resid);
        }
    }
}

